/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.util.comparator;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class KBObjectsModifiedDateComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "modifiedDate ASC, title ASC";
    public static final String ORDER_BY_DESC = "modifiedDate DESC, title ASC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"modifiedDate, title"};
    public static final String ORDER_BY_MODEL_ASC = "modelFolder DESC, modifiedDate ASC, title ASC";
    public static final String ORDER_BY_MODEL_DESC = "modelFolder DESC, modifiedDate DESC, title ASC";
    private final boolean _ascending;
    private final boolean _orderByModel;

    public KBObjectsModifiedDateComparator() {
        this(false, false);
    }

    public KBObjectsModifiedDateComparator(boolean ascending) {
        this(ascending, false);
    }

    public KBObjectsModifiedDateComparator(boolean ascending, boolean orderByModel) {
        this._ascending = ascending;
        this._orderByModel = orderByModel;
    }

    @Override
    public int compare(T t1, T t2) {
        int value = 0;
        Date modifiedDate1 = this.getModifiedDate(t1);
        Date modifiedDate2 = this.getModifiedDate(t2);
        String title1 = this.getTitle(t1);
        String title2 = this.getTitle(t2);
        if (this._orderByModel) {
            if (t1 instanceof KBFolder && t2 instanceof KBFolder) {
                value = DateUtil.compareTo(modifiedDate1, modifiedDate2);
                if (value == 0) {
                    value = title1.compareToIgnoreCase(title2);
                }
            } else if (t1 instanceof KBFolder) {
                value = -1;
            } else if (t2 instanceof KBFolder) {
                value = 1;
            } else {
                value = DateUtil.compareTo(modifiedDate1, modifiedDate2);
                if (value == 0) {
                    value = title1.compareToIgnoreCase(title2);
                }
            }
        } else {
            value = DateUtil.compareTo(modifiedDate1, modifiedDate2);
            if (value == 0) {
                value = title1.compareToIgnoreCase(title2);
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._orderByModel) {
            if (this._ascending) {
                return ORDER_BY_MODEL_ASC;
            }
            return ORDER_BY_MODEL_DESC;
        }
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    protected Date getModifiedDate(Object obj) {
        if (obj instanceof KBArticle) {
            KBArticle kbArticle = (KBArticle)obj;
            return kbArticle.getModifiedDate();
        }
        KBFolder kbFolder = (KBFolder)obj;
        return kbFolder.getModifiedDate();
    }

    protected String getTitle(Object obj) {
        if (obj instanceof KBArticle) {
            KBArticle kbArticle = (KBArticle)obj;
            return kbArticle.getTitle();
        }
        KBFolder kbFolder = (KBFolder)obj;
        return kbFolder.getName();
    }
}

