/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.taglib.servlet.taglib;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.taglib.internal.servlet.ServletContextUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class JournalArticleTag
extends IncludeTag {
    private static final String _PAGE = "/journal_article/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleTag.class);
    private JournalArticle _article;
    private JournalArticleDisplay _articleDisplay;
    private String _articleId;
    private String _ddmTemplateKey;
    private long _groupId;
    private String _languageId;
    private boolean _showTitle;
    private String _wrapperCssClass;

    @Override
    public int doStartTag() throws JspException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        PortletRequestModel portletRequestModel = new PortletRequestModel(portletRequest, portletResponse);
        this._article = JournalArticleLocalServiceUtil.fetchLatestArticle(this._groupId, this._articleId, 0);
        try {
            this._articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay(this._article.getGroupId(), this._article.getArticleId(), this._article.getVersion(), this._ddmTemplateKey, "view", this.getLanguageId(), 1, portletRequestModel, themeDisplay);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to get journal article display", pe);
            }
            return 0;
        }
        return super.doStartTag();
    }

    public String getArticleId() {
        return this._articleId;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public String getWrapperCssClass() {
        return this._wrapperCssClass;
    }

    public boolean isShowTitle() {
        return this._showTitle;
    }

    public void setArticleId(String articleId) {
        this._articleId = articleId;
    }

    public void setDdmTemplateKey(String ddmTemplateKey) {
        this._ddmTemplateKey = ddmTemplateKey;
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setShowTitle(boolean showTitle) {
        this._showTitle = showTitle;
    }

    public void setWrapperCssClass(String wrapperCssClass) {
        this._wrapperCssClass = wrapperCssClass;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._article = null;
        this._articleId = null;
        this._ddmTemplateKey = null;
        this._groupId = 0L;
        this._languageId = null;
        this._showTitle = false;
        this._wrapperCssClass = null;
    }

    protected String getDdmTemplateKey() {
        if (Validator.isNotNull(this._ddmTemplateKey)) {
            return this._ddmTemplateKey;
        }
        return this._article.getDDMTemplateKey();
    }

    protected String getLanguageId() {
        if (Validator.isNotNull(this._languageId)) {
            return this._languageId;
        }
        return LanguageUtil.getLanguageId(this.request);
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-journal:journal-article:articleDisplay", (Object)this._articleDisplay);
        httpServletRequest.setAttribute("liferay-journal:journal-article:showTitle", (Object)String.valueOf(this._showTitle));
        httpServletRequest.setAttribute("liferay-journal:journal-article:wrapperCssClass", (Object)this._wrapperCssClass);
    }
}

