/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.item.selector.taglib.servlet.taglib;

import com.liferay.item.selector.taglib.internal.servlet.ServletContextUtil;
import com.liferay.item.selector.taglib.internal.servlet.item.selector.ItemSelectorUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.taglib.util.IncludeTag;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class GroupSelectorTag
extends IncludeTag {
    private static final long[] _CLASS_NAME_IDS = new long[]{ClassNameLocalServiceUtil.getClassNameId(Company.class), ClassNameLocalServiceUtil.getClassNameId(Group.class), ClassNameLocalServiceUtil.getClassNameId(Organization.class)};
    private List<Group> _groups;
    private int _groupsCount;

    public void setGroups(List<Group> groups) {
        this._groups = groups;
    }

    public void setGroupsCount(int groupsCount) {
        this._groupsCount = groupsCount;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._groups = null;
        this._groupsCount = 0;
    }

    protected List<Group> getGroups(HttpServletRequest httpServletRequest) {
        if (this._groups != null) {
            return this._groups;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String keywords = ParamUtil.getString(httpServletRequest, "keywords");
        LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
        groupParams.put("site", Boolean.TRUE);
        int cur = ParamUtil.getInteger(httpServletRequest, "cur", 1);
        int delta = ParamUtil.getInteger(httpServletRequest, "delta", SearchContainer.DEFAULT_DELTA);
        int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd(cur, delta);
        return GroupLocalServiceUtil.search(themeDisplay.getCompanyId(), _CLASS_NAME_IDS, keywords, groupParams, startAndEnd[0], startAndEnd[1], null);
    }

    protected int getGroupsCount(HttpServletRequest httpServletRequest) {
        if (this._groups != null || this._groupsCount > 0) {
            return this._groupsCount;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String keywords = ParamUtil.getString(httpServletRequest, "keywords");
        LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
        groupParams.put("site", Boolean.TRUE);
        return GroupLocalServiceUtil.searchCount(themeDisplay.getCompanyId(), _CLASS_NAME_IDS, keywords, groupParams);
    }

    @Override
    protected String getPage() {
        return "/group_selector/page.jsp";
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-item-selector:group-selector:groups", this.getGroups(httpServletRequest));
        httpServletRequest.setAttribute("liferay-item-selector:group-selector:groupsCount", (Object)this.getGroupsCount(httpServletRequest));
        httpServletRequest.setAttribute("liferay-item-selector:group-selector:itemSelector", (Object)ItemSelectorUtil.getItemSelector());
    }
}

