/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.item.selector.taglib.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.item.selector.taglib.servlet.taglib.RepositoryEntryBrowserTag;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class ItemSelectorRepositoryEntryManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;

    public ItemSelectorRepositoryEntryManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._httpServletRequest = httpServletRequest;
        this._currentURLObj = PortletURLUtil.getCurrent(this._liferayPortletRequest, this._liferayPortletResponse);
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._httpServletRequest, "order-by"));
                });
            }
        };
    }

    public String getOrderByType() {
        return ParamUtil.getString(this._httpServletRequest, "orderByType", "asc");
    }

    public PortletURL getSearchURL() throws PortletException {
        PortletURL searchURL = PortletURLUtil.clone(this._currentURLObj, this._liferayPortletResponse);
        searchURL.setParameter("keywords", (String)null);
        searchURL.setParameter("resetCur", Boolean.TRUE.toString());
        return searchURL;
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        String orderByType = this.getOrderByType();
        sortingURL.setParameter("orderByType", Objects.equals(orderByType, "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public ViewTypeItemList getViewTypes() throws PortletException {
        PortletURL displayStyleURL = PortletURLUtil.clone(this._getPortletURL(), this._liferayPortletResponse);
        return new ViewTypeItemList(displayStyleURL, this._getDisplayStyle()){
            {
                if (ArrayUtil.contains(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._getDisplayViews(), "icon")) {
                    this.addCardViewTypeItem();
                }
                if (ArrayUtil.contains(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._getDisplayViews(), "descriptive")) {
                    this.addListViewTypeItem();
                }
                if (ArrayUtil.contains(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._getDisplayViews(), "list")) {
                    this.addTableViewTypeItem();
                }
            }
        };
    }

    public boolean isDisabled() {
        return false;
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL currentSortingURL = PortletURLUtil.clone(this._getPortletURL(), this._liferayPortletResponse);
        currentSortingURL.setParameter("orderByType", this.getOrderByType());
        currentSortingURL.setParameter("orderByCol", this._getOrderByCol());
        return currentSortingURL;
    }

    private String _getDisplayStyle() {
        return GetterUtil.getString(this._httpServletRequest.getAttribute("liferay-item-selector:repository-entry-browser:displayStyle"));
    }

    private String[] _getDisplayViews() {
        return RepositoryEntryBrowserTag.DISPLAY_STYLES;
    }

    private String _getOrderByCol() {
        return ParamUtil.getString(this._httpServletRequest, "orderByCol", "title");
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                HashMap<String, String> orderColumnsMap = new HashMap<String, String>();
                orderColumnsMap.put("modifiedDate", "modified-date");
                orderColumnsMap.put("size", "size");
                orderColumnsMap.put("title", "title");
                for (Map.Entry orderByColEntry : orderColumnsMap.entrySet()) {
                    this.add(dropdownItem -> {
                        String orderByCol = (String)orderByColEntry.getKey();
                        dropdownItem.setActive(orderByCol.equals(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._getOrderByCol()));
                        dropdownItem.setHref(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._getCurrentSortingURL(), "orderByCol", orderByCol);
                        dropdownItem.setLabel(LanguageUtil.get(ItemSelectorRepositoryEntryManagementToolbarDisplayContext.this._httpServletRequest, (String)orderByColEntry.getValue()));
                    });
                }
            }
        };
    }

    private PortletURL _getPortletURL() {
        return (PortletURL)this._httpServletRequest.getAttribute("liferay-item-selector:repository-entry-browser:portletURL");
    }
}

