/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Rating")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Rating")
public class Rating {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Double bestRating;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Creator creator;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateCreated;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateModified;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Double ratingValue;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Double worstRating;

    @Schema(description="The best possible rating an asset can receive (normalized to 1.0 by default).")
    public Double getBestRating() {
        return this.bestRating;
    }

    public void setBestRating(Double bestRating) {
        this.bestRating = bestRating;
    }

    @JsonIgnore
    public void setBestRating(UnsafeSupplier<Double, Exception> bestRatingUnsafeSupplier) {
        try {
            this.bestRating = bestRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The rating's creator.")
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The rating's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time a field of the rating changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The rating's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The rating's value.")
    public Double getRatingValue() {
        return this.ratingValue;
    }

    public void setRatingValue(Double ratingValue) {
        this.ratingValue = ratingValue;
    }

    @JsonIgnore
    public void setRatingValue(UnsafeSupplier<Double, Exception> ratingValueUnsafeSupplier) {
        try {
            this.ratingValue = ratingValueUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The worst possible rating an asset can receive (normalized to 0.0 by default).")
    public Double getWorstRating() {
        return this.worstRating;
    }

    public void setWorstRating(Double worstRating) {
        this.worstRating = worstRating;
    }

    @JsonIgnore
    public void setWorstRating(UnsafeSupplier<Double, Exception> worstRatingUnsafeSupplier) {
        try {
            this.worstRating = worstRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rating)) {
            return false;
        }
        Rating rating = (Rating)object;
        return Objects.equals(this.toString(), rating.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.bestRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"bestRating\": ");
            sb.append(this.bestRating);
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(this.id);
        }
        if (this.ratingValue != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"ratingValue\": ");
            sb.append(this.ratingValue);
        }
        if (this.worstRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"worstRating\": ");
            sb.append(this.worstRating);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

