/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.ParentKnowledgeBaseFolder;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="KnowledgeBaseFolder")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"name"})
@XmlRootElement(name="KnowledgeBaseFolder")
public class KnowledgeBaseFolder {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Creator creator;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateCreated;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateModified;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String description;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer numberOfKnowledgeBaseArticles;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer numberOfKnowledgeBaseFolders;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected ParentKnowledgeBaseFolder parentKnowledgeBaseFolder;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected Long parentKnowledgeBaseFolderId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long siteId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected ViewableBy viewableBy;

    @Schema(description="The folder's creator.")
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the folder was created.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time the folder was modified.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The folder's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The folder's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The folder's main title/name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of Knowledge Base articles in this folder.")
    public Integer getNumberOfKnowledgeBaseArticles() {
        return this.numberOfKnowledgeBaseArticles;
    }

    public void setNumberOfKnowledgeBaseArticles(Integer numberOfKnowledgeBaseArticles) {
        this.numberOfKnowledgeBaseArticles = numberOfKnowledgeBaseArticles;
    }

    @JsonIgnore
    public void setNumberOfKnowledgeBaseArticles(UnsafeSupplier<Integer, Exception> numberOfKnowledgeBaseArticlesUnsafeSupplier) {
        try {
            this.numberOfKnowledgeBaseArticles = numberOfKnowledgeBaseArticlesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of Knowledge Base folders in this folder.")
    public Integer getNumberOfKnowledgeBaseFolders() {
        return this.numberOfKnowledgeBaseFolders;
    }

    public void setNumberOfKnowledgeBaseFolders(Integer numberOfKnowledgeBaseFolders) {
        this.numberOfKnowledgeBaseFolders = numberOfKnowledgeBaseFolders;
    }

    @JsonIgnore
    public void setNumberOfKnowledgeBaseFolders(UnsafeSupplier<Integer, Exception> numberOfKnowledgeBaseFoldersUnsafeSupplier) {
        try {
            this.numberOfKnowledgeBaseFolders = numberOfKnowledgeBaseFoldersUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The folder's parent Knowledge Base folder, if it exists.")
    public ParentKnowledgeBaseFolder getParentKnowledgeBaseFolder() {
        return this.parentKnowledgeBaseFolder;
    }

    public void setParentKnowledgeBaseFolder(ParentKnowledgeBaseFolder parentKnowledgeBaseFolder) {
        this.parentKnowledgeBaseFolder = parentKnowledgeBaseFolder;
    }

    @JsonIgnore
    public void setParentKnowledgeBaseFolder(UnsafeSupplier<ParentKnowledgeBaseFolder, Exception> parentKnowledgeBaseFolderUnsafeSupplier) {
        try {
            this.parentKnowledgeBaseFolder = parentKnowledgeBaseFolderUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the folder's parent Knowledge Base folder, if such a parent folder exists.")
    public Long getParentKnowledgeBaseFolderId() {
        return this.parentKnowledgeBaseFolderId;
    }

    public void setParentKnowledgeBaseFolderId(Long parentKnowledgeBaseFolderId) {
        this.parentKnowledgeBaseFolderId = parentKnowledgeBaseFolderId;
    }

    @JsonIgnore
    public void setParentKnowledgeBaseFolderId(UnsafeSupplier<Long, Exception> parentKnowledgeBaseFolderIdUnsafeSupplier) {
        try {
            this.parentKnowledgeBaseFolderId = parentKnowledgeBaseFolderIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this folder is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the folder's default permissions.")
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = viewableByUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KnowledgeBaseFolder)) {
            return false;
        }
        KnowledgeBaseFolder knowledgeBaseFolder = (KnowledgeBaseFolder)object;
        return Objects.equals(this.toString(), knowledgeBaseFolder.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (int i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(KnowledgeBaseFolder._escape(this.description));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(this.id);
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(KnowledgeBaseFolder._escape(this.name));
            sb.append("\"");
        }
        if (this.numberOfKnowledgeBaseArticles != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfKnowledgeBaseArticles\": ");
            sb.append(this.numberOfKnowledgeBaseArticles);
        }
        if (this.numberOfKnowledgeBaseFolders != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfKnowledgeBaseFolders\": ");
            sb.append(this.numberOfKnowledgeBaseFolders);
        }
        if (this.parentKnowledgeBaseFolder != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentKnowledgeBaseFolder\": ");
            sb.append(String.valueOf(this.parentKnowledgeBaseFolder));
        }
        if (this.parentKnowledgeBaseFolderId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentKnowledgeBaseFolderId\": ");
            sb.append(this.parentKnowledgeBaseFolderId);
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append(this.siteId);
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

