/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.AdaptedImage;
import com.liferay.headless.delivery.dto.v1_0.AggregateRating;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategory;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Document")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Document")
public class Document {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected AdaptedImage[] adaptedImages;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected AggregateRating aggregateRating;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String contentUrl;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Creator creator;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateCreated;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateModified;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String description;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long documentFolderId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String encodingFormat;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String fileExtension;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] keywords;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer numberOfComments;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected RelatedContent[] relatedContents;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long sizeInBytes;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected TaxonomyCategory[] taxonomyCategories;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected Long[] taxonomyCategoryIds;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String title;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected ViewableBy viewableBy;

    @Schema(description="An array of images in several resolutions and sizes, created by the Adaptive Media framework.")
    public AdaptedImage[] getAdaptedImages() {
        return this.adaptedImages;
    }

    public void setAdaptedImages(AdaptedImage[] adaptedImages) {
        this.adaptedImages = adaptedImages;
    }

    @JsonIgnore
    public void setAdaptedImages(UnsafeSupplier<AdaptedImage[], Exception> adaptedImagesUnsafeSupplier) {
        try {
            this.adaptedImages = adaptedImagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's average rating.")
    public AggregateRating getAggregateRating() {
        return this.aggregateRating;
    }

    public void setAggregateRating(AggregateRating aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    @JsonIgnore
    public void setAggregateRating(UnsafeSupplier<AggregateRating, Exception> aggregateRatingUnsafeSupplier) {
        try {
            this.aggregateRating = aggregateRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's relative URL.")
    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    @JsonIgnore
    public void setContentUrl(UnsafeSupplier<String, Exception> contentUrlUnsafeSupplier) {
        try {
            this.contentUrl = contentUrlUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's creator.")
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time a field of the document changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the `DocumentFolder` where this document is stored.")
    public Long getDocumentFolderId() {
        return this.documentFolderId;
    }

    public void setDocumentFolderId(Long documentFolderId) {
        this.documentFolderId = documentFolderId;
    }

    @JsonIgnore
    public void setDocumentFolderId(UnsafeSupplier<Long, Exception> documentFolderIdUnsafeSupplier) {
        try {
            this.documentFolderId = documentFolderIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's content type (e.g., `application/pdf`, etc.).")
    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public void setEncodingFormat(UnsafeSupplier<String, Exception> encodingFormatUnsafeSupplier) {
        try {
            this.encodingFormat = encodingFormatUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's file extension.")
    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @JsonIgnore
    public void setFileExtension(UnsafeSupplier<String, Exception> fileExtensionUnsafeSupplier) {
        try {
            this.fileExtension = fileExtensionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the document.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of comments on the document.")
    public Integer getNumberOfComments() {
        return this.numberOfComments;
    }

    public void setNumberOfComments(Integer numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    @JsonIgnore
    public void setNumberOfComments(UnsafeSupplier<Integer, Exception> numberOfCommentsUnsafeSupplier) {
        try {
            this.numberOfComments = numberOfCommentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public RelatedContent[] getRelatedContents() {
        return this.relatedContents;
    }

    public void setRelatedContents(RelatedContent[] relatedContents) {
        this.relatedContents = relatedContents;
    }

    @JsonIgnore
    public void setRelatedContents(UnsafeSupplier<RelatedContent[], Exception> relatedContentsUnsafeSupplier) {
        try {
            this.relatedContents = relatedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's size in bytes.")
    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @JsonIgnore
    public void setSizeInBytes(UnsafeSupplier<Long, Exception> sizeInBytesUnsafeSupplier) {
        try {
            this.sizeInBytes = sizeInBytesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The categories associated with this document.")
    public TaxonomyCategory[] getTaxonomyCategories() {
        return this.taxonomyCategories;
    }

    public void setTaxonomyCategories(TaxonomyCategory[] taxonomyCategories) {
        this.taxonomyCategories = taxonomyCategories;
    }

    @JsonIgnore
    public void setTaxonomyCategories(UnsafeSupplier<TaxonomyCategory[], Exception> taxonomyCategoriesUnsafeSupplier) {
        try {
            this.taxonomyCategories = taxonomyCategoriesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only field that adds `TaxonomyCategory` instances to the document.")
    public Long[] getTaxonomyCategoryIds() {
        return this.taxonomyCategoryIds;
    }

    public void setTaxonomyCategoryIds(Long[] taxonomyCategoryIds) {
        this.taxonomyCategoryIds = taxonomyCategoryIds;
    }

    @JsonIgnore
    public void setTaxonomyCategoryIds(UnsafeSupplier<Long[], Exception> taxonomyCategoryIdsUnsafeSupplier) {
        try {
            this.taxonomyCategoryIds = taxonomyCategoryIdsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The document's main title/name.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<String, Exception> titleUnsafeSupplier) {
        try {
            this.title = titleUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the document's default permissions.")
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = viewableByUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Document)) {
            return false;
        }
        Document document = (Document)object;
        return Objects.equals(this.toString(), document.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.adaptedImages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"adaptedImages\": ");
            sb.append("[");
            for (i = 0; i < this.adaptedImages.length; ++i) {
                sb.append(String.valueOf(this.adaptedImages[i]));
                if (i + 1 >= this.adaptedImages.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.aggregateRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(this.aggregateRating));
        }
        if (this.contentUrl != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentUrl\": ");
            sb.append("\"");
            sb.append(Document._escape(this.contentUrl));
            sb.append("\"");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(Document._escape(this.description));
            sb.append("\"");
        }
        if (this.documentFolderId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"documentFolderId\": ");
            sb.append(this.documentFolderId);
        }
        if (this.encodingFormat != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(Document._escape(this.encodingFormat));
            sb.append("\"");
        }
        if (this.fileExtension != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fileExtension\": ");
            sb.append("\"");
            sb.append(Document._escape(this.fileExtension));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(this.id);
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(Document._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.numberOfComments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfComments\": ");
            sb.append(this.numberOfComments);
        }
        if (this.relatedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < this.relatedContents.length; ++i) {
                sb.append(String.valueOf(this.relatedContents[i]));
                if (i + 1 >= this.relatedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.sizeInBytes != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sizeInBytes\": ");
            sb.append(this.sizeInBytes);
        }
        if (this.taxonomyCategories != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategories\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategories.length; ++i) {
                sb.append(String.valueOf(this.taxonomyCategories[i]));
                if (i + 1 >= this.taxonomyCategories.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.taxonomyCategoryIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryIds\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryIds.length; ++i) {
                sb.append(this.taxonomyCategoryIds[i]);
                if (i + 1 >= this.taxonomyCategoryIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.title != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(Document._escape(this.title));
            sb.append("\"");
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

