/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.common.spi.resource;

import com.liferay.headless.common.spi.odata.entity.CommentEntityModel;
import com.liferay.message.boards.exception.DiscussionMaxCommentsException;
import com.liferay.message.boards.exception.MessageSubjectException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.function.Function;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MultivaluedMap;

public class SPICommentResource<T> {
    private static final EntityModel _entityModel = new CommentEntityModel();
    private final CommentManager _commentManager;
    private final Company _company;
    private final UnsafeFunction<Comment, T, Exception> _transformUnsafeFunction;

    public SPICommentResource(CommentManager commentManager, Company company, UnsafeFunction<Comment, T, Exception> transformUnsafeFunction) {
        this._commentManager = commentManager;
        this._company = company;
        this._transformUnsafeFunction = transformUnsafeFunction;
    }

    public void deleteComment(Long commentId) throws Exception {
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkDeletePermission(commentId);
        this._commentManager.deleteComment(commentId);
    }

    public T getComment(Long commentId) throws Exception {
        Comment comment = this._commentManager.fetchComment(commentId);
        this._checkViewPermission(comment);
        return this._transformUnsafeFunction.apply(comment);
    }

    public Page<T> getCommentCommentsPage(Long commentId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getComments(commentId, search, filter, pagination, sorts);
    }

    public Page<T> getEntityCommentsPage(long groupId, String className, long classPK, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Discussion discussion = this._commentManager.getDiscussion(this._getUserId(), groupId, className, classPK, this._createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this._getComments(rootDiscussionComment.getCommentId(), search, filter, pagination, sorts);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    public T postCommentComment(Comment parentComment, String text) throws Exception {
        return this._postComment(() -> this._commentManager.addComment(this._getUserId(), parentComment.getClassName(), parentComment.getClassPK(), "", parentComment.getCommentId(), "", StringBundler.concat("<p>", text, "</p>"), this._createServiceContextFunction()), parentComment.getGroupId(), parentComment.getClassName(), parentComment.getClassPK());
    }

    public T postEntityComment(long groupId, String className, long classPK, String text) throws Exception {
        return this._postComment(() -> this._commentManager.addComment(this._getUserId(), groupId, className, classPK, "", "", StringBundler.concat("<p>", text, "</p>"), this._createServiceContextFunction()), groupId, className, classPK);
    }

    public T putComment(Long commentId, String text) throws Exception {
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkUpdatePermission(commentId);
        Comment existingComment = this._commentManager.fetchComment(commentId);
        try {
            this._commentManager.updateComment(existingComment.getUserId(), existingComment.getClassName(), existingComment.getClassPK(), commentId, "", StringBundler.concat("<p>", text, "</p>"), this._createServiceContextFunction());
            return this._transformUnsafeFunction.apply(this._commentManager.fetchComment(commentId));
        }
        catch (MessageSubjectException mse) {
            throw new ClientErrorException("Comment text is null", 422, (Throwable)mse);
        }
    }

    private void _checkViewPermission(Comment comment) throws Exception {
        if (comment == null) {
            throw new NotFoundException();
        }
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkViewPermission(this._company.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
    }

    private Function<String, ServiceContext> _createServiceContextFunction() {
        return className -> {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setWorkflowAction(1);
            return serviceContext;
        };
    }

    private Page<T> _getComments(Long parentCommentId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add(new TermFilter("parentMessageId", String.valueOf(parentCommentId)), BooleanClauseOccur.MUST);
        }, filter, MBMessage.class, search, pagination, queryConfig -> queryConfig.setSelectedFieldNames("entryClassPK"), searchContext -> {
            searchContext.setAttribute("discussion", Boolean.TRUE);
            searchContext.setAttribute("searchPermissionContext", (Serializable)((Object)""));
            searchContext.setCompanyId(this._company.getCompanyId());
        }, document -> this._transformUnsafeFunction.apply(this._commentManager.fetchComment(GetterUtil.getLong(document.get("entryClassPK")))), sorts);
    }

    private DiscussionPermission _getDiscussionPermission() {
        return this._commentManager.getDiscussionPermission(PermissionThreadLocal.getPermissionChecker());
    }

    private long _getUserId() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.getUserId();
    }

    private T _postComment(UnsafeSupplier<Long, ? extends Exception> addCommentUnsafeSupplier, long groupId, String className, long classPK) throws Exception {
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkAddPermission(this._company.getCompanyId(), groupId, className, classPK);
        try {
            long commentId = addCommentUnsafeSupplier.get();
            return this._transformUnsafeFunction.apply(this._commentManager.fetchComment(commentId));
        }
        catch (DiscussionMaxCommentsException dmce) {
            throw new ClientErrorException("Maximum number of comments has been reached", 422, (Throwable)dmce);
        }
        catch (DuplicateCommentException dce) {
            throw new ClientErrorException("A comment with the same text already exists", 409, (Throwable)dce);
        }
        catch (MessageSubjectException mse) {
            throw new ClientErrorException("Comment text is null", 422, (Throwable)mse);
        }
    }
}

