/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.soy.servlet.taglib;

import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolvedPackageNameUtil;
import com.liferay.frontend.taglib.soy.internal.util.SoyComponentRendererProvider;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.soy.renderer.ComponentDescriptor;
import com.liferay.portal.template.soy.renderer.SoyComponentRenderer;
import com.liferay.portal.template.soy.util.SoyContext;
import com.liferay.portal.template.soy.util.SoyContextFactoryUtil;
import com.liferay.taglib.util.ParamAndPropertyAncestorTagImpl;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class TemplateRendererTag
extends ParamAndPropertyAncestorTagImpl {
    private String _componentId;
    private Map<String, Object> _context;
    private Set<String> _dependencies;
    private Boolean _hydrate;
    private String _module;
    private boolean _setServletContext;
    private String _templateNamespace;
    private Boolean _useNamespace = true;
    private Boolean _wrapper;

    @Override
    public int doEndTag() throws JspException {
        JspWriter jspWriter = this.pageContext.getOut();
        Map<String, Object> context = this.getContext();
        try {
            this.prepareContext(context);
            ComponentDescriptor componentDescriptor = new ComponentDescriptor(this.getTemplateNamespace(), this.getModule(), this.getComponentId(), this._dependencies, this.isWrapper(), this.isRenderJavaScript(), this.isPositionInLine());
            SoyComponentRenderer soyComponentRenderer = SoyComponentRendererProvider.getSoyComponentRenderer();
            soyComponentRenderer.renderSoyComponent(this.request, (Writer)jspWriter, componentDescriptor, context);
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.cleanUp();
        }
        return 6;
    }

    @Override
    public int doStartTag() {
        return 1;
    }

    public String getComponentId() {
        return this._componentId;
    }

    public boolean getHydrate() {
        if (this._hydrate != null) {
            return this._hydrate;
        }
        Map<String, Object> context = this.getContext();
        return Validator.isNotNull(this._componentId) || Validator.isNotNull(this._module) || Validator.isNotNull(context.get("data"));
    }

    public String getModule() {
        String namespace;
        if (!this._useNamespace.booleanValue()) {
            return this._module;
        }
        if (this._setServletContext) {
            namespace = NPMResolvedPackageNameUtil.get(this.servletContext);
        } else {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            namespace = NPMResolvedPackageNameUtil.get(httpServletRequest);
        }
        return namespace + "/" + this._module;
    }

    public String getTemplateNamespace() {
        return this._templateNamespace;
    }

    public boolean getUseNamespace() {
        return this._useNamespace;
    }

    public void putHTMLValue(String key, String value) {
        Map<String, Object> context = this.getContext();
        if (context instanceof SoyContext) {
            ((SoyContext)context).putHTML(key, value);
        } else {
            this.putValue(key, value);
        }
    }

    public void putValue(String key, Object value) {
        Map<String, Object> context = this.getContext();
        context.put(key, value);
    }

    @Override
    public void release() {
        super.release();
        this._setServletContext = false;
    }

    public void setComponentId(String componentId) {
        this._componentId = componentId;
    }

    public void setContext(Map<String, Object> context) {
        this._context = context instanceof SoyContext ? context : SoyContextFactoryUtil.createSoyContext(context);
    }

    public void setDependencies(Set<String> dependencies) {
        this._dependencies = dependencies;
    }

    public void setHydrate(boolean hydrate) {
        this._hydrate = hydrate;
    }

    public void setModule(String module) {
        this._module = module;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
        this._setServletContext = true;
    }

    public void setTemplateNamespace(String namespace) {
        this._templateNamespace = namespace;
    }

    public void setUseNamespace(boolean useNamespace) {
        this._useNamespace = useNamespace;
    }

    public void setWrapper(boolean wrapper) {
        this._wrapper = wrapper;
    }

    protected void cleanUp() {
        if (!ServerDetector.isResin()) {
            this._componentId = null;
            this._context = null;
            this._dependencies = null;
            this._hydrate = null;
            this._module = null;
            this._templateNamespace = null;
            this._useNamespace = true;
            this._wrapper = null;
        }
    }

    protected Map<String, Object> getContext() {
        if (this._context == null) {
            this._context = SoyContextFactoryUtil.createSoyContext();
        }
        return this._context;
    }

    protected boolean isPositionInLine() {
        Boolean positionInline = null;
        String fragmentId = ParamUtil.getString(this.request, "p_f_id");
        if (Validator.isNotNull(fragmentId)) {
            positionInline = true;
        }
        if (positionInline == null) {
            PortletDisplay portletDisplay;
            String portletId;
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive()) {
                positionInline = true;
            }
            if (Validator.isNotNull(portletId = (portletDisplay = themeDisplay.getPortletDisplay()).getId()) && themeDisplay.isPortletEmbedded(themeDisplay.getScopeGroupId(), themeDisplay.getLayout(), portletId)) {
                positionInline = true;
            }
        }
        if (positionInline == null) {
            positionInline = false;
        }
        return positionInline;
    }

    protected boolean isRenderJavaScript() {
        return this.getHydrate() && Validator.isNotNull(this.getModule());
    }

    protected boolean isWrapper() {
        if (this._wrapper != null) {
            return this._wrapper;
        }
        return this.isRenderJavaScript();
    }

    protected void prepareContext(Map<String, Object> context) {
    }
}

