/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.servlet.taglib;

import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolvedPackageNameUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.ParamAndPropertyAncestorTagImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class ComponentTag
extends ParamAndPropertyAncestorTagImpl {
    private static final char[] _UNSAFE_MODULE_NAME_CHARS = new char[]{'.', '-'};
    private String _componentId;
    private String _containerId;
    private Map<String, Object> _context;
    private final JSONSerializer _jsonSerializer = JSONFactoryUtil.createJSONSerializer();
    private String _module;
    private boolean _setServletContext;

    @Override
    public int doEndTag() throws JspException {
        try {
            this._renderJavaScript();
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.cleanUp();
        }
        return 6;
    }

    @Override
    public int doStartTag() {
        return 1;
    }

    public String getComponentId() {
        return this._componentId;
    }

    public String getContainerId() {
        return this._containerId;
    }

    public String getModule() {
        String namespace = "";
        namespace = this._setServletContext ? NPMResolvedPackageNameUtil.get(this.servletContext) : NPMResolvedPackageNameUtil.get(this.request);
        return namespace + "/" + this._module;
    }

    @Override
    public void release() {
        super.release();
        this._setServletContext = false;
    }

    public void setComponentId(String componentId) {
        this._componentId = componentId;
    }

    public void setContainerId(String containerId) {
        this._containerId = containerId;
    }

    public void setContext(Map<String, Object> context) {
        this._context = context;
    }

    public void setModule(String module) {
        this._module = module;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
        this._setServletContext = true;
    }

    protected void cleanUp() {
        if (!ServerDetector.isResin()) {
            this._componentId = null;
            this._containerId = null;
            this._context = null;
            this._module = null;
        }
    }

    protected Map<String, Object> getContext() {
        return this._context;
    }

    protected boolean isPositionInline() {
        Boolean positionInline = null;
        String fragmentId = ParamUtil.getString(this.request, "p_f_id");
        if (Validator.isNotNull(fragmentId)) {
            positionInline = true;
        }
        if (positionInline == null) {
            PortletDisplay portletDisplay;
            String portletId;
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive()) {
                positionInline = true;
            }
            if (Validator.isNotNull(portletId = (portletDisplay = themeDisplay.getPortletDisplay()).getId()) && themeDisplay.isPortletEmbedded(themeDisplay.getScopeGroupId(), themeDisplay.getLayout(), portletId)) {
                positionInline = true;
            }
        }
        if (positionInline == null) {
            positionInline = false;
        }
        return positionInline;
    }

    private static String _getModuleName(String module) {
        String moduleName = StringUtil.extractLast(module, '/');
        return StringUtil.removeChars(moduleName, _UNSAFE_MODULE_NAME_CHARS);
    }

    private void _renderJavaScript() throws IOException {
        StringBundler sb = new StringBundler(12);
        sb.append("Liferay.component('");
        sb.append(this.getComponentId());
        sb.append("', new ");
        String module = this.getModule();
        String moduleName = ComponentTag._getModuleName(module);
        sb.append(moduleName);
        sb.append(".default(");
        Map<String, Object> context = this.getContext();
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        context.put("namespace", portletDisplay.getNamespace());
        context.put("spritemap", themeDisplay.getPathThemeImages() + "/lexicon/icons.svg");
        sb.append(this._jsonSerializer.serializeDeep(context));
        String containerId = this.getContainerId();
        if (Validator.isNotNull(containerId)) {
            sb.append(", '");
            sb.append(containerId);
            sb.append("'");
        }
        sb.append("), { portletId: '");
        sb.append(portletDisplay.getId());
        sb.append("'});");
        if (this.isPositionInline()) {
            ScriptData scriptData = new ScriptData();
            scriptData.append(PortalUtil.getPortletId(this.request), sb.toString(), module + " as " + moduleName, ScriptData.ModulesType.ES6);
            JspWriter jspWriter = this.pageContext.getOut();
            scriptData.writeTo((Writer)jspWriter);
            return;
        }
        ScriptData scriptData = (ScriptData)this.request.getAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
        if (scriptData == null) {
            scriptData = new ScriptData();
            this.request.setAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA", (Object)scriptData);
        }
        scriptData.append(PortalUtil.getPortletId(this.request), sb.toString(), module + " as " + moduleName, ScriptData.ModulesType.ES6);
    }
}

