/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.form.navigator.internal.osgi.commands;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorCategoryUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorEntry;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"osgi.command.function=getPossibleConfigurations", "osgi.command.scope=formNavigator"}, service={FormNavigatorOSGiCommands.class})
public class FormNavigatorOSGiCommands {
    private final Collector<CharSequence, ?, String> _collectorCSV = Collectors.joining(",");
    private ServiceTrackerList<FormNavigatorEntry, FormNavigatorEntry> _formNavigatorEntries;
    private ServiceTrackerMap<String, List<FormNavigatorEntry>> _formNavigatorEntriesMap;

    public void getPossibleConfigurations() {
        for (String formNavigatorId : this._getAllFormNavigatorIds()) {
            String[] formNavigatorCategoryKeys = FormNavigatorCategoryUtil.getKeys(formNavigatorId);
            System.out.println(formNavigatorId);
            for (String formNavigatorCategoryKey : formNavigatorCategoryKeys) {
                String line = this._getCategoryLine(formNavigatorId, formNavigatorCategoryKey);
                System.out.print("\t");
                System.out.print(line);
            }
        }
    }

    public void getPossibleConfigurations(String formNavigatorId) {
        String[] formNavigatorCategoryKeys;
        for (String formNavigatorCategoryKey : formNavigatorCategoryKeys = FormNavigatorCategoryUtil.getKeys(formNavigatorId)) {
            System.out.print(this._getCategoryLine(formNavigatorId, formNavigatorCategoryKey));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._formNavigatorEntries = ServiceTrackerListFactory.open(bundleContext, FormNavigatorEntry.class);
        this._formNavigatorEntriesMap = ServiceTrackerMapFactory.openMultiValueMap(bundleContext, FormNavigatorEntry.class, null, (serviceReference, emitter) -> {
            FormNavigatorEntry formNavigatorEntry = (FormNavigatorEntry)bundleContext.getService(serviceReference);
            String key = this._getKey(formNavigatorEntry.getFormNavigatorId(), formNavigatorEntry.getCategoryKey());
            emitter.emit(key);
            bundleContext.ungetService(serviceReference);
        });
    }

    private Set<String> _getAllFormNavigatorIds() {
        HashSet<String> allFormNavigatorIds = new HashSet<String>();
        this._formNavigatorEntries.forEach(formNavigatorEntry -> allFormNavigatorIds.add(formNavigatorEntry.getFormNavigatorId()));
        return allFormNavigatorIds;
    }

    private String _getCategoryLine(String formNavigatorId, String formNavigatorCategoryKey) {
        List<FormNavigatorEntry> formNavigatorEntries = this._formNavigatorEntriesMap.getService(this._getKey(formNavigatorId, formNavigatorCategoryKey));
        if (formNavigatorEntries == null) {
            return "";
        }
        Stream formNavigatorEntriesStream = formNavigatorEntries.stream();
        Stream<String> formNavigatorKeysStream = formNavigatorEntriesStream.map(FormNavigatorEntry::getKey);
        String formNavigatorEntryKeysCSV = formNavigatorKeysStream.collect(this._collectorCSV);
        StringBundler sb = new StringBundler(4);
        if (Validator.isNotNull(formNavigatorCategoryKey)) {
            sb.append(formNavigatorCategoryKey);
            sb.append("=");
        }
        sb.append(formNavigatorEntryKeysCSV);
        sb.append("\n");
        return sb.toString();
    }

    private String _getKey(String formNavigatorId, String formNavigatorCategoryId) {
        return formNavigatorId + formNavigatorCategoryId;
    }
}

