/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.form.navigator.internal.configuration;

import com.liferay.frontend.taglib.form.navigator.internal.configuration.FormNavigatorConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.frontend.taglib.form.navigator.internal.configuration.FormNavigatorConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={FormNavigatorEntryConfigurationParser.class})
public class FormNavigatorEntryConfigurationParser {
    private static final Pattern _pattern = Pattern.compile("^(?:(?<key>.*)=)?(?<value>.*)$", 8);
    private FormNavigatorConfiguration _formNavigatorConfiguration;
    private Map<String, List<String>> _formNavigatorEntryKeysMap;

    public Optional<List<String>> getFormNavigatorEntryKeys(String categoryKey, String context) {
        List<String> formNavigatorEntryKeys = null;
        if (Validator.isNotNull(categoryKey) && Validator.isNotNull(context)) {
            formNavigatorEntryKeys = this._formNavigatorEntryKeysMap.get(context + "." + categoryKey);
        } else if (Validator.isNotNull(context)) {
            formNavigatorEntryKeys = this._formNavigatorEntryKeysMap.get(context);
        }
        if (formNavigatorEntryKeys == null) {
            formNavigatorEntryKeys = this._formNavigatorEntryKeysMap.get(categoryKey);
        }
        return Optional.ofNullable(formNavigatorEntryKeys);
    }

    public String getFormNavigatorId() {
        return this._formNavigatorConfiguration.formNavigatorId();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._formNavigatorConfiguration = ConfigurableUtil.createConfigurable(FormNavigatorConfiguration.class, properties);
        String[] formNavigatorEntryKeys = this._formNavigatorConfiguration.formNavigatorEntryKeys();
        this._formNavigatorEntryKeysMap = new HashMap<String, List<String>>();
        for (String line : formNavigatorEntryKeys) {
            Matcher matcher = _pattern.matcher(line);
            while (matcher.find()) {
                String key = matcher.group("key");
                String value = matcher.group("value");
                if (key == null) {
                    key = "";
                }
                this._formNavigatorEntryKeysMap.put(key.trim(), this._splitKeys(value));
            }
        }
    }

    private List<String> _splitKeys(String formNavigatorEntryKeys) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (String key : StringUtil.split(formNavigatorEntryKeys)) {
            keys.add(key.trim());
        }
        return new ArrayList<String>(keys);
    }
}

