/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.form.navigator.internal.configuration;

import com.liferay.frontend.taglib.form.navigator.context.FormNavigatorContextProvider;
import com.liferay.frontend.taglib.form.navigator.internal.configuration.FormNavigatorEntryConfigurationRetriever;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorEntry;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorEntryConfigurationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={FormNavigatorEntryConfigurationHelper.class})
public class FormNavigatorEntryConfigurationHelperImpl
implements FormNavigatorEntryConfigurationHelper {
    private static final Log _log = LogFactoryUtil.getLog(FormNavigatorEntryConfigurationHelperImpl.class);
    private ServiceTrackerMap<String, FormNavigatorContextProvider> _formNavigatorContextProviderMap;
    private ServiceTrackerMap<String, FormNavigatorEntry> _formNavigatorEntriesMap;
    @Reference
    private FormNavigatorEntryConfigurationRetriever _formNavigatorEntryConfigurationRetriever;

    @Override
    public <T> Optional<List<FormNavigatorEntry<T>>> getFormNavigatorEntries(String formNavigatorId, String categoryKey, T formModelBean) {
        String context = this._getContext(formNavigatorId, formModelBean);
        Optional<List<String>> optionalFormNavigatorEntryKeys = this._formNavigatorEntryConfigurationRetriever.getFormNavigatorEntryKeys(formNavigatorId, categoryKey, context);
        return optionalFormNavigatorEntryKeys.map(formNavigatorEntryKeys -> this._getFormNavigatorEntries(formNavigatorId, (List<String>)formNavigatorEntryKeys));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._formNavigatorEntriesMap = ServiceTrackerMapFactory.openSingleValueMap(bundleContext, FormNavigatorEntry.class, null, (serviceReference, emitter) -> {
            FormNavigatorEntry formNavigatorEntry = (FormNavigatorEntry)bundleContext.getService(serviceReference);
            emitter.emit(this._getKey(formNavigatorEntry.getKey(), formNavigatorEntry.getFormNavigatorId()));
            bundleContext.ungetService(serviceReference);
        });
        this._formNavigatorContextProviderMap = ServiceTrackerMapFactory.openSingleValueMap(bundleContext, FormNavigatorContextProvider.class, "formNavigatorId");
    }

    @Deactivate
    protected void deactivate() {
        this._formNavigatorEntriesMap.close();
        this._formNavigatorContextProviderMap.close();
    }

    private <T> String _getContext(String formNavigatorId, T formModelBean) {
        FormNavigatorContextProvider formNavigatorContextProvider = this._formNavigatorContextProviderMap.getService(formNavigatorId);
        if (formNavigatorContextProvider != null) {
            return formNavigatorContextProvider.getContext(formModelBean);
        }
        if (formModelBean == null) {
            return "add";
        }
        return "update";
    }

    private <T> List<FormNavigatorEntry<T>> _getFormNavigatorEntries(String formNavigatorId, List<String> formNavigatorEntryKeys) {
        ArrayList<FormNavigatorEntry<T>> formNavigatorEntries = new ArrayList<FormNavigatorEntry<T>>();
        for (String key : formNavigatorEntryKeys) {
            FormNavigatorEntry<T> formNavigatorEntry = this._getFormNavigatorEntry(key, formNavigatorId);
            if (formNavigatorEntry == null) continue;
            formNavigatorEntries.add(formNavigatorEntry);
        }
        return formNavigatorEntries;
    }

    private <T> FormNavigatorEntry<T> _getFormNavigatorEntry(String key, String formNavigatorId) {
        FormNavigatorEntry formNavigatorEntry = this._formNavigatorEntriesMap.getService(this._getKey(key, formNavigatorId));
        if (formNavigatorEntry == null && _log.isWarnEnabled()) {
            _log.warn(String.format("There is no form navigator entry for the form '%s' with key '%'", formNavigatorId, key));
        }
        return formNavigatorEntry;
    }

    private String _getKey(String key, String formNavigatorId) {
        return formNavigatorId + "." + key;
    }
}

