/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.clay.servlet.taglib.soy.base;

import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.frontend.taglib.clay.internal.ClayTagContextContributorsProvider;
import com.liferay.frontend.taglib.clay.internal.js.loader.modules.extender.npm.NPMResolverProvider;
import com.liferay.frontend.taglib.clay.servlet.taglib.contributor.ClayTagContextContributor;
import com.liferay.frontend.taglib.soy.servlet.taglib.TemplateRendererTag;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletResponse;

public abstract class BaseClayTag
extends TemplateRendererTag {
    private String _componentBaseName;
    private String _moduleBaseName;
    private String _namespace;

    @Override
    public int doStartTag() {
        String contributorKey;
        super.setWrapper(false);
        Map<String, Object> context = this.getContext();
        if (Validator.isNull(context.get("spritemap"))) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String pathThemeImages = themeDisplay.getPathThemeImages();
            this.putValue("spritemap", pathThemeImages.concat("/clay/icons.svg"));
        }
        String namespace = this.getNamespace();
        String[] namespacedParams = this.getNamespacedParams();
        if (Validator.isNotNull(namespace) && namespacedParams != null) {
            for (String parameterName : namespacedParams) {
                String parameterValue = (String)context.get(parameterName);
                this.putValue(parameterName, namespace + parameterValue);
            }
        }
        if (Validator.isNotNull(contributorKey = GetterUtil.getString(context.get("contributorKey")))) {
            this._populateContext(contributorKey);
        }
        this.setTemplateNamespace(this._componentBaseName + ".render");
        return super.doStartTag();
    }

    @Override
    public String getModule() {
        NPMResolver npmResolver = NPMResolverProvider.getNPMResolver();
        if (npmResolver == null) {
            return "";
        }
        return npmResolver.resolveModuleName(StringBundler.concat("clay-", this._moduleBaseName, "/lib/", this._componentBaseName));
    }

    public String getNamespace() {
        if (this._namespace != null) {
            return this._namespace;
        }
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        if (portletResponse != null) {
            this._namespace = portletResponse.getNamespace();
        }
        return this._namespace;
    }

    public void setComponentBaseName(String componentBaseName) {
        this._componentBaseName = componentBaseName;
    }

    public void setContributorKey(String contributorKey) {
        this.putValue("contributorKey", contributorKey);
    }

    public void setData(Map<String, String> data) {
        this.putValue("data", data);
    }

    public void setDefaultEventHandler(String defaultEventHandler) {
        if (Validator.isNotNull(defaultEventHandler)) {
            this.putValue("defaultEventHandler", defaultEventHandler);
        }
    }

    public void setElementClasses(String elementClasses) {
        this.putValue("elementClasses", elementClasses);
    }

    public void setId(String id) {
        this.putValue("id", id);
    }

    public void setModuleBaseName(String moduleBaseName) {
        this._moduleBaseName = moduleBaseName;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public void setSpritemap(String spritemap) {
        this.putValue("spritemap", spritemap);
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        if (!ServerDetector.isResin()) {
            this._componentBaseName = null;
            this._moduleBaseName = null;
            this._namespace = null;
        }
    }

    protected String[] getNamespacedParams() {
        return null;
    }

    private void _populateContext(String contributorKey) {
        List<ClayTagContextContributor> clayTagContextContributors = ClayTagContextContributorsProvider.getClayTagContextContributors(contributorKey);
        if (clayTagContextContributors == null) {
            return;
        }
        for (ClayTagContextContributor clayTagContextContributor : clayTagContextContributors) {
            clayTagContextContributor.populate(this.getContext());
        }
    }
}

