/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.clay.servlet.taglib.soy;

import com.liferay.frontend.taglib.clay.internal.ClayTableTagSchemaContributorsProvider;
import com.liferay.frontend.taglib.clay.internal.ClayTagDataSourceProvider;
import com.liferay.frontend.taglib.clay.internal.servlet.taglib.display.context.TableDefaults;
import com.liferay.frontend.taglib.clay.servlet.taglib.contributor.ClayTableTagSchemaContributor;
import com.liferay.frontend.taglib.clay.servlet.taglib.data.ClayTagDataSource;
import com.liferay.frontend.taglib.clay.servlet.taglib.model.table.Schema;
import com.liferay.frontend.taglib.clay.servlet.taglib.model.table.Size;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.base.BaseClayTag;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TableTag<T>
extends BaseClayTag {
    private Schema _schema = new Schema();

    @Override
    public int doStartTag() {
        List<ClayTableTagSchemaContributor> clayTableTagSchemaContributors;
        this.setComponentBaseName("ClayTable");
        this.setHydrate(true);
        this.setModuleBaseName("table");
        int returnValue = super.doStartTag();
        ClayTagDataSource<T> clayTagDataSource = this.getClayTagDataSource();
        if (clayTagDataSource != null) {
            this._populateContext(clayTagDataSource);
        }
        if ((clayTableTagSchemaContributors = this.getTableTagSchemaContributors()) != null) {
            this._populateSchema(clayTableTagSchemaContributors);
        }
        this.putValue("schema", this._schema.toMap());
        Map<String, Object> context = this.getContext();
        boolean selectable = GetterUtil.getBoolean(context.get("selectable"));
        boolean showCheckbox = GetterUtil.getBoolean(context.get("showCheckbox"), (boolean)TableDefaults.isShowCheckbox(selectable));
        this.setShowCheckbox(showCheckbox);
        return returnValue;
    }

    public void setActionsMenuVariant(String actionsMenuVariant) {
        this.putValue("actionsMenuVariant", actionsMenuVariant);
    }

    public void setDataSourceKey(String dataSourceKey) {
        this.putValue("dataSourceKey", dataSourceKey);
    }

    public void setItems(Collection<?> items) {
        this.putValue("items", items);
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public void setSelectable(Boolean selectable) {
        this.putValue("selectable", selectable);
    }

    public void setShowActionsMenu(Boolean showActionsMenu) {
        this.putValue("showActionsMenu", showActionsMenu);
    }

    public void setShowCheckbox(Boolean showCheckbox) {
        this.putValue("showCheckbox", showCheckbox);
    }

    public void setSize(Size size) {
        String sizeValue = null;
        if (size != null) {
            sizeValue = size.getValue();
        }
        this.putValue("size", sizeValue);
    }

    public void setTableClasses(String tableClasses) {
        this.putValue("tableClasses", tableClasses);
    }

    public void setTableSchemaContributorKey(String tableSchemaContributorKey) {
        this.putValue("tableSchemaContributorKey", tableSchemaContributorKey);
    }

    public void setUseDefaultClasses(Boolean useDefaultClasses) {
        this.putValue("useDefaultClasses", useDefaultClasses);
    }

    public void setWrapTable(Boolean wrapTable) {
        this.putValue("wrapTable", wrapTable);
    }

    protected ClayTagDataSource<T> getClayTagDataSource() {
        Map<String, Object> context = this.getContext();
        String dataSourceKey = (String)context.get("dataSourceKey");
        if (Validator.isNull(dataSourceKey)) {
            return null;
        }
        return ClayTagDataSourceProvider.getClayTagDataSource(dataSourceKey);
    }

    protected List<ClayTableTagSchemaContributor> getTableTagSchemaContributors() {
        Map<String, Object> context = this.getContext();
        String tableSchemaContributorKey = GetterUtil.getString(context.get("tableSchemaContributorKey"));
        if (Validator.isNull(tableSchemaContributorKey)) {
            return null;
        }
        return ClayTableTagSchemaContributorsProvider.getClayTableTagSchemaContributors(tableSchemaContributorKey);
    }

    private void _populateContext(ClayTagDataSource<T> clayTagDataSource) {
        Map<String, Object> context = this.getContext();
        if (context.get("items") == null) {
            this.setItems(clayTagDataSource.getItems(this.request));
        }
    }

    private void _populateSchema(List<ClayTableTagSchemaContributor> clayTableTagSchemaContributors) {
        for (ClayTableTagSchemaContributor clayTableTagSchemaContributor : clayTableTagSchemaContributors) {
            clayTableTagSchemaContributor.populate(this._schema);
        }
    }
}

