/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.taglib.clay.servlet.taglib.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.display.context.ManagementToolbarDisplayContext;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BaseManagementToolbarDisplayContext
implements ManagementToolbarDisplayContext {
    protected final PortletURL currentURLObj;
    protected final LiferayPortletRequest liferayPortletRequest;
    protected final LiferayPortletResponse liferayPortletResponse;
    protected final HttpServletRequest request;
    private static final Log _log = LogFactoryUtil.getLog(BaseManagementToolbarDisplayContext.class);

    public BaseManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest) {
        this.liferayPortletRequest = liferayPortletRequest;
        this.liferayPortletResponse = liferayPortletResponse;
        this.request = httpServletRequest;
        this.currentURLObj = PortletURLUtil.getCurrent(liferayPortletRequest, liferayPortletResponse);
    }

    @Override
    public List<DropdownItem> getFilterDropdownItems() {
        DropdownItemList filterDropdownItems = new DropdownItemList(){
            {
                List<DropdownItem> orderByDropdownItems;
                List<DropdownItem> filterNavigationDropdownItems = BaseManagementToolbarDisplayContext.this.getFilterNavigationDropdownItems();
                if (filterNavigationDropdownItems != null) {
                    this.addGroup(dropdownGroupItem -> {
                        dropdownGroupItem.setDropdownItems(filterNavigationDropdownItems);
                        dropdownGroupItem.setLabel(BaseManagementToolbarDisplayContext.this.getFilterNavigationDropdownItemsLabel());
                    });
                }
                if ((orderByDropdownItems = BaseManagementToolbarDisplayContext.this.getOrderByDropdownItems()) != null) {
                    this.addGroup(dropdownGroupItem -> {
                        dropdownGroupItem.setDropdownItems(orderByDropdownItems);
                        dropdownGroupItem.setLabel(BaseManagementToolbarDisplayContext.this.getOrderByDropdownItemsLabel());
                    });
                }
            }
        };
        if (filterDropdownItems.isEmpty()) {
            return null;
        }
        return filterDropdownItems;
    }

    @Override
    public String getNamespace() {
        return this.liferayPortletResponse.getNamespace();
    }

    @Override
    public String getSortingOrder() {
        return this.getOrderByType();
    }

    @Override
    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        String orderByCol = this.getOrderByCol();
        if (Validator.isNotNull(orderByCol)) {
            sortingURL.setParameter(this.getOrderByColParam(), orderByCol);
        }
        sortingURL.setParameter(this.getOrderByTypeParam(), Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    @Override
    public List<ViewTypeItem> getViewTypeItems() {
        if (ArrayUtil.isEmpty(this.getDisplayViews())) {
            return null;
        }
        return new ViewTypeItemList(this.getPortletURL(), this.getDisplayStyle()){
            {
                if (ArrayUtil.contains(BaseManagementToolbarDisplayContext.this.getDisplayViews(), "icon")) {
                    this.addCardViewTypeItem();
                }
                if (ArrayUtil.contains(BaseManagementToolbarDisplayContext.this.getDisplayViews(), "descriptive")) {
                    this.addListViewTypeItem();
                }
                if (ArrayUtil.contains(BaseManagementToolbarDisplayContext.this.getDisplayViews(), "list")) {
                    this.addTableViewTypeItem();
                }
            }
        };
    }

    protected String getDefaultDisplayStyle() {
        return "list";
    }

    protected Map<String, String> getDefaultEntriesMap(String[] entryKeys) {
        if (entryKeys == null || entryKeys.length == 0) {
            return null;
        }
        LinkedHashMap<String, String> entriesMap = new LinkedHashMap<String, String>();
        for (String entryKey : entryKeys) {
            entriesMap.put(entryKey, entryKey);
        }
        return entriesMap;
    }

    protected String getDisplayStyle() {
        return ParamUtil.getString(this.request, "displayStyle", this.getDefaultDisplayStyle());
    }

    protected String[] getDisplayViews() {
        return new String[0];
    }

    protected List<DropdownItem> getDropdownItems(final Map<String, String> entriesMap, final PortletURL entryURL, final String parameterName, final String parameterValue) {
        if (entriesMap == null || entriesMap.isEmpty()) {
            return null;
        }
        return new DropdownItemList(){
            {
                for (Map.Entry entry : entriesMap.entrySet()) {
                    this.add(dropdownItem -> {
                        if (parameterValue != null) {
                            dropdownItem.setActive(parameterValue.equals(entry.getValue()));
                        }
                        dropdownItem.setHref(entryURL, parameterName, entry.getValue());
                        dropdownItem.setLabel(LanguageUtil.get(BaseManagementToolbarDisplayContext.this.request, (String)entry.getKey()));
                    });
                }
            }
        };
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        return this.getDropdownItems(this.getNavigationEntriesMap(), this.getPortletURL(), this.getNavigationParam(), this.getNavigation());
    }

    protected String getFilterNavigationDropdownItemsLabel() {
        return LanguageUtil.get(this.request, "filter-by-navigation");
    }

    protected String getNavigation() {
        return ParamUtil.getString(this.liferayPortletRequest, this.getNavigationParam(), "all");
    }

    protected Map<String, String> getNavigationEntriesMap() {
        return this.getDefaultEntriesMap(this.getNavigationKeys());
    }

    protected String[] getNavigationKeys() {
        return null;
    }

    protected String getNavigationParam() {
        return "navigation";
    }

    protected String getOrderByCol() {
        return ParamUtil.getString(this.liferayPortletRequest, this.getOrderByColParam());
    }

    protected String getOrderByColParam() {
        return "orderByCol";
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return this.getDropdownItems(this.getOrderByEntriesMap(), this.getPortletURL(), this.getOrderByColParam(), this.getOrderByCol());
    }

    protected String getOrderByDropdownItemsLabel() {
        return LanguageUtil.get(this.request, "order-by");
    }

    protected Map<String, String> getOrderByEntriesMap() {
        return this.getDefaultEntriesMap(this.getOrderByKeys());
    }

    protected String[] getOrderByKeys() {
        return null;
    }

    protected String getOrderByType() {
        return ParamUtil.getString(this.liferayPortletRequest, this.getOrderByTypeParam(), "asc");
    }

    protected String getOrderByTypeParam() {
        return "orderByType";
    }

    protected PortletURL getPortletURL() {
        try {
            return PortletURLUtil.clone(this.currentURLObj, this.liferayPortletResponse);
        }
        catch (PortletException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, pe);
            }
            Object portletURL = this.liferayPortletResponse.createRenderURL();
            portletURL.setParameters(this.currentURLObj.getParameterMap());
            return portletURL;
        }
    }
}

