/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.image.editor.capability;

import com.liferay.frontend.image.editor.capability.ImageEditorCapability;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class BaseImageEditorCapability
implements ImageEditorCapability {
    private String _moduleName;
    private List<URL> _resourceURLs;

    public BaseImageEditorCapability() {
        this.initModuleName();
        this.initResourceURLs();
    }

    @Override
    public String getModuleName() {
        return this._moduleName;
    }

    @Override
    public List<URL> getResourceURLs() {
        return this._resourceURLs;
    }

    @Override
    public void prepareContext(Map<String, Object> context, HttpServletRequest httpServletRequest) {
    }

    protected Bundle getBundle() {
        return FrameworkUtil.getBundle(this.getClass());
    }

    protected void initModuleName() {
        Bundle bundle = this.getBundle();
        URL url = bundle.getEntry("package.json");
        if (url == null) {
            this._moduleName = "";
            return;
        }
        try {
            String json = StringUtil.read(url.openStream());
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(json);
            this._moduleName = GetterUtil.getString(jsonObject.getString("name")) + "@" + GetterUtil.getString(jsonObject.getString("version"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initResourceURLs() {
        this._resourceURLs = new ArrayList<URL>();
        Bundle bundle = this.getBundle();
        Enumeration enumeration = bundle.findEntries("META-INF/resources", "*.es.js", true);
        if (enumeration != null) {
            this._resourceURLs.addAll(Collections.list(enumeration));
        }
    }
}

