/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.flags.taglib.servlet.taglib.soy;

import com.liferay.flags.configuration.FlagsGroupServiceConfiguration;
import com.liferay.flags.taglib.internal.frontend.js.loader.modules.extender.npm.NPMResolverProvider;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.frontend.taglib.soy.servlet.taglib.ComponentRendererTag;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class FlagsTag
extends ComponentRendererTag {
    private static final Log _log = LogFactoryUtil.getLog(FlagsTag.class);

    @Override
    public int doStartTag() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String randomNamespace = StringUtil.randomId() + "_";
        try {
            Map<String, Object> context = this.getContext();
            boolean enabled = GetterUtil.getBoolean(context.get("enabled"), true);
            Company company = themeDisplay.getCompany();
            this.putValue("companyName", company.getName());
            this.putValue("flagsEnabled", this._isFlagsEnabled(themeDisplay));
            this.putValue("formData", this._getDataJSONObject(context));
            this.putValue("id", randomNamespace + "id");
            this.putValue("enabled", enabled);
            boolean label = GetterUtil.getBoolean(context.get("label"), true);
            this.putValue("label", label);
            this.putValue("pathTermsOfUse", themeDisplay.getPathMain() + "/portal/terms_of_use");
            this.putValue("pathThemeImages", themeDisplay.getPathThemeImages());
            this.putValue("portletNamespace", PortalUtil.getPortletNamespace("com_liferay_flags_web_portlet_FlagsPortlet"));
            boolean signedIn = themeDisplay.isSignedIn();
            this.putValue("signedIn", signedIn);
            if (signedIn) {
                User user = themeDisplay.getUser();
                this.putValue("reporterEmailAddress", user.getEmailAddress());
            }
            this.putValue("uri", this._getURI());
            this.putValue("reasons", this._getReasons(themeDisplay.getCompanyId()));
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        this.setTemplateNamespace("Flags.render");
        return super.doStartTag();
    }

    @Override
    public String getModule() {
        NPMResolver npmResolver = NPMResolverProvider.getNPMResolver();
        if (npmResolver == null) {
            return "";
        }
        return npmResolver.resolveModuleName("flags-taglib/flags/Flags.es");
    }

    public void setClassName(String className) {
        this.putValue("className", className);
    }

    public void setClassPK(long classPK) {
        this.putValue("classPK", classPK);
    }

    public void setContentTitle(String contentTitle) {
        this.putValue("contentTitle", contentTitle);
    }

    public void setElementClasses(String elementClasses) {
        this.putValue("elementClasses", elementClasses);
    }

    public void setEnabled(boolean enabled) {
        this.putValue("enabled", enabled);
    }

    public void setLabel(boolean label) {
        this.putValue("label", label);
    }

    public void setMessage(String message) {
        this.putValue("message", LanguageUtil.get(this.request, message));
    }

    public void setReportedUserId(long reportedUserId) {
        this.putValue("reportedUserId", reportedUserId);
    }

    private String _getCurrentURL() {
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        if (portletRequest == null || portletResponse == null) {
            return PortalUtil.getCurrentURL(this.request);
        }
        PortletURL currentURLObj = PortletURLUtil.getCurrent(PortalUtil.getLiferayPortletRequest(portletRequest), PortalUtil.getLiferayPortletResponse(portletResponse));
        return currentURLObj.toString();
    }

    private JSONObject _getDataJSONObject(Map<String, Object> context) {
        String namespace = PortalUtil.getPortletNamespace("com_liferay_flags_web_portlet_FlagsPortlet");
        return JSONUtil.put(namespace + "className", context.get("className")).put(namespace + "classPK", context.get("classPK")).put(namespace + "contentTitle", context.get("contentTitle")).put(namespace + "contentURL", this._getCurrentURL()).put(namespace + "reportedUserId", context.get("reportedUserId"));
    }

    private Map<String, String> _getReasons(long companyId) throws PortalException {
        FlagsGroupServiceConfiguration flagsGroupServiceConfiguration = ConfigurationProviderUtil.getCompanyConfiguration(FlagsGroupServiceConfiguration.class, companyId);
        HashMap<String, String> reasons = new HashMap<String, String>();
        for (String reason : flagsGroupServiceConfiguration.reasons()) {
            reasons.put(reason, LanguageUtil.get(this.request, reason));
        }
        return reasons;
    }

    private String _getURI() {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create(this.request, "com_liferay_flags_web_portlet_FlagsPortlet", "ACTION_PHASE");
        portletURL.setParameter("javax.portlet.action", "/flags/edit_entry");
        return portletURL.toString();
    }

    private boolean _isFlagsEnabled(ThemeDisplay themeDisplay) throws PortalException {
        FlagsGroupServiceConfiguration flagsGroupServiceConfiguration = ConfigurationProviderUtil.getCompanyConfiguration(FlagsGroupServiceConfiguration.class, themeDisplay.getCompanyId());
        return flagsGroupServiceConfiguration.guestUsersEnabled() || themeDisplay.isSignedIn();
    }
}

