/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.lar;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.test.util.lar.BaseStagedModelDataHandlerTestCase;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseWorkflowedStagedModelDataHandlerTestCase
extends BaseStagedModelDataHandlerTestCase {
    @Test
    public void testExportWorkflowedStagedModels() throws Exception {
        this.initExport();
        List<StagedModel> stagedModels = null;
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled(true);
            stagedModels = this.addWorkflowedStagedModels(this.stagingGroup);
        }
        finally {
            WorkflowThreadLocal.setEnabled(workflowEnabled);
        }
        for (StagedModel stagedModel : stagedModels) {
            Assert.assertTrue("Staged model is not a workflowed model", stagedModel instanceof WorkflowedModel);
            try {
                StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedModel);
            }
            catch (PortletDataException pde) {
                Assert.assertEquals("An unexpected error occurred during the export", 9L, pde.getType());
            }
            this.validateWorkflowedExport(this.portletDataContext, stagedModel);
        }
    }

    protected abstract List<StagedModel> addWorkflowedStagedModels(Group var1) throws Exception;

    protected Element getExportStagedModelElement(PortletDataContext portletDataContext, StagedModel stagedModel) {
        Element rootElement = portletDataContext.getExportDataRootElement();
        Class<?> modelClass = stagedModel.getModelClass();
        Element modelElement = rootElement.element(modelClass.getSimpleName());
        Assert.assertNotNull("Unable to find model element", modelElement);
        XPath xPath = SAXReaderUtil.createXPath("staged-model[@path ='" + ExportImportPathUtil.getModelPath(stagedModel) + "']");
        return (Element)xPath.selectSingleNode(modelElement);
    }

    protected void validateWorkflowedExport(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(stagedModel.getModelClassName());
        WorkflowedModel workflowedModel = (WorkflowedModel)((Object)stagedModel);
        Element exportStagedModelElement = this.getExportStagedModelElement(portletDataContext, stagedModel);
        if (ArrayUtil.contains(stagedModelDataHandler.getExportableStatuses(), workflowedModel.getStatus())) {
            Assert.assertNotNull("Staged model should be exported", exportStagedModelElement);
        } else {
            Assert.assertNull("Staged model should not be exported", exportStagedModelElement);
        }
    }
}

