/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.lar;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.asset.test.util.AssetTestUtil;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.IdentityServiceContextFunction;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.service.test.ServiceTestUtil;
import com.liferay.portlet.ratings.util.test.RatingsTestUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseStagedModelDataHandlerTestCase {
    @DeleteAfterTestRun
    protected Group liveGroup;
    protected Element missingReferencesElement;
    protected PortletDataContext portletDataContext;
    protected Element rootElement;
    @DeleteAfterTestRun
    protected Group stagingGroup;
    protected UserIdStrategy userIdStrategy;
    protected ZipReader zipReader;
    protected ZipWriter zipWriter;

    @Before
    public void setUp() throws Exception {
        this.liveGroup = GroupTestUtil.addGroup();
        this.stagingGroup = GroupTestUtil.addGroup();
        ServiceTestUtil.setUser(TestPropsValues.getUser());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(this.stagingGroup.getGroupId());
        ServiceContextThreadLocal.pushServiceContext(serviceContext);
    }

    @After
    public void tearDown() throws Exception {
        ServiceContextThreadLocal.popServiceContext();
    }

    @Test
    public void testCleanAssetCategoriesAndTags() throws Exception {
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        AssetEntry assetEntry = this.fetchAssetEntry(stagedModel, this.stagingGroup);
        if (assetEntry == null) {
            return;
        }
        AssetVocabulary assetVocabulary = AssetTestUtil.addVocabulary(this.stagingGroup.getGroupId());
        AssetCategory assetCategory = AssetTestUtil.addCategory(this.stagingGroup.getGroupId(), assetVocabulary.getVocabularyId());
        AssetTag assetTag = AssetTestUtil.addTag(this.stagingGroup.getGroupId());
        assetEntry = AssetEntryLocalServiceUtil.updateEntry(TestPropsValues.getUserId(), this.stagingGroup.getGroupId(), assetEntry.getCreateDate(), assetEntry.getModifiedDate(), assetEntry.getClassName(), assetEntry.getClassPK(), assetEntry.getClassUuid(), assetEntry.getClassTypeId(), new long[]{assetCategory.getCategoryId()}, new String[]{assetTag.getName()}, assetEntry.isListable(), assetEntry.isVisible(), assetEntry.getStartDate(), assetEntry.getEndDate(), assetEntry.getPublishDate(), assetEntry.getExpirationDate(), assetEntry.getMimeType(), assetEntry.getTitle(), assetEntry.getDescription(), assetEntry.getSummary(), assetEntry.getUrl(), assetEntry.getLayoutUuid(), assetEntry.getHeight(), assetEntry.getWidth(), assetEntry.getPriority());
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull(importedStagedModel);
        AssetEntry importedAssetEntry = this.fetchAssetEntry(importedStagedModel, this.liveGroup);
        Assert.assertNotNull(importedAssetEntry);
        List<AssetTag> assetTags = importedAssetEntry.getTags();
        Assert.assertFalse(assetTags.toString(), assetTags.isEmpty());
        List<AssetCategory> assetCategories = importedAssetEntry.getCategories();
        Assert.assertFalse(assetCategories.toString(), assetCategories.isEmpty());
        assetEntry = this.fetchAssetEntry(stagedModel, this.stagingGroup);
        assetEntry = AssetEntryLocalServiceUtil.updateEntry(TestPropsValues.getUserId(), this.stagingGroup.getGroupId(), assetEntry.getCreateDate(), assetEntry.getModifiedDate(), assetEntry.getClassName(), assetEntry.getClassPK(), assetEntry.getClassUuid(), assetEntry.getClassTypeId(), new long[0], new String[0], assetEntry.isListable(), assetEntry.isVisible(), assetEntry.getStartDate(), assetEntry.getEndDate(), assetEntry.getPublishDate(), assetEntry.getExpirationDate(), assetEntry.getMimeType(), assetEntry.getTitle(), assetEntry.getDescription(), assetEntry.getSummary(), assetEntry.getUrl(), assetEntry.getLayoutUuid(), assetEntry.getHeight(), assetEntry.getWidth(), assetEntry.getPriority());
        this.exportImportStagedModel(stagedModel);
        importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull(importedStagedModel);
        importedAssetEntry = this.fetchAssetEntry(importedStagedModel, this.liveGroup);
        Assert.assertNotNull(importedAssetEntry);
        assetTags = importedAssetEntry.getTags();
        Assert.assertTrue(assetTags.toString(), assetTags.isEmpty());
        assetCategories = importedAssetEntry.getCategories();
        Assert.assertTrue(assetCategories.toString(), assetCategories.isEmpty());
    }

    @Test
    public void testCleanStagedModelDataHandler() throws Exception {
        this.initExport();
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        this.addComments(stagedModel);
        this.addRatings(stagedModel);
        StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedModel);
        this.validateExport(this.portletDataContext, stagedModel, dependentStagedModelsMap);
        this.initImport();
        this.deleteStagedModel(stagedModel, dependentStagedModelsMap, this.stagingGroup);
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull(exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel(this.portletDataContext, exportedStagedModel);
        StagedModel importedStagedModel = this.getStagedModel(exportedStagedModel.getUuid(), this.liveGroup);
        this.validateImportedStagedModel(exportedStagedModel, importedStagedModel);
        Assert.assertNotEquals(exportedStagedModel.getPrimaryKeyObj(), importedStagedModel.getPrimaryKeyObj());
    }

    @Test
    public void testExportImportWithDefaultData() throws Exception {
        this.initExport();
        Map<String, List<StagedModel>> defaultDependentStagedModelsMap = this.addDefaultDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addDefaultStagedModel(this.stagingGroup, defaultDependentStagedModelsMap);
        if (stagedModel == null) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedModel);
        this.validateExport(this.portletDataContext, stagedModel, defaultDependentStagedModelsMap);
        Map<String, List<StagedModel>> secondDependentStagedModelsMap = this.addDefaultDependentStagedModelsMap(this.liveGroup);
        this.addDefaultStagedModel(this.liveGroup, secondDependentStagedModelsMap);
        this.initImport();
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull(exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel(this.portletDataContext, exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel(this.portletDataContext, exportedStagedModel);
        String uuid = exportedStagedModel.getUuid();
        StagedModel importedModel = this.getStagedModel(uuid, this.liveGroup);
        Assert.assertNotNull(importedModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastPublishDate() throws Exception {
        if (!this.supportLastPublishDateUpdate()) {
            return;
        }
        HashMap<String, List<StagedModel>> dependentStagedModelsMap = new HashMap<String, List<StagedModel>>();
        StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        Assert.assertNull(stagedGroupedModel.getLastPublishDate());
        this.initExport();
        Map<String, String[]> parameterMap = this.portletDataContext.getParameterMap();
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        try {
            ExportImportThreadLocal.setPortletStagingInProcess(true);
            StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedGroupedModel);
        }
        finally {
            ExportImportThreadLocal.setPortletStagingInProcess(false);
        }
        Assert.assertEquals(this.portletDataContext.getEndDate(), stagedGroupedModel.getLastPublishDate());
        Date originalLastPublishDate = stagedGroupedModel.getLastPublishDate();
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        try {
            ExportImportThreadLocal.setPortletStagingInProcess(true);
            StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedGroupedModel);
        }
        finally {
            ExportImportThreadLocal.setPortletStagingInProcess(false);
        }
        Assert.assertEquals(originalLastPublishDate, stagedGroupedModel.getLastPublishDate());
    }

    @Test
    public void testStagedModelDataHandler() throws Exception {
        this.initExport();
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        StagedModelAssets stagedModelAssets = this.updateAssetEntry(stagedModel, this.stagingGroup);
        this.addComments(stagedModel);
        this.addRatings(stagedModel);
        StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedModel);
        this.validateExport(this.portletDataContext, stagedModel, dependentStagedModelsMap);
        this.initImport();
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull(exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel(this.portletDataContext, exportedStagedModel);
        this.validateImport(stagedModel, stagedModelAssets, dependentStagedModelsMap, this.liveGroup);
    }

    @Test
    public void testVersioning() throws Exception {
        if (!this.isVersionableStagedModel()) {
            return;
        }
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        stagedModel = this.addVersion(stagedModel);
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull(importedStagedModel);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
    }

    @Test
    public void testVersioning2() throws Exception {
        if (!this.isVersionableStagedModel()) {
            return;
        }
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        Thread.sleep(4000L);
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
        stagedModel = this.addVersion(stagedModel);
        this.exportImportStagedModel(stagedModel);
        importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
    }

    @Test
    public void testVersioningExportImportTwice() throws Exception {
        if (!this.isVersionableStagedModel()) {
            return;
        }
        Map<String, List<StagedModel>> dependentStagedModelsMap = this.addDependentStagedModelsMap(this.stagingGroup);
        StagedModel stagedModel = this.addStagedModel(this.stagingGroup, dependentStagedModelsMap);
        stagedModel = this.addVersion(stagedModel);
        this.exportImportStagedModel(stagedModel);
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull(importedStagedModel);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
        this.exportImportStagedModel(stagedModel);
        importedStagedModel = this.getStagedModel(stagedModel.getUuid(), this.liveGroup);
        Assert.assertNotNull(importedStagedModel);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
    }

    protected void addComments(StagedModel stagedModel) throws Exception {
        if (!this.isCommentableStagedModel()) {
            return;
        }
        User user = TestPropsValues.getUser();
        String className = ExportImportClassedModelUtil.getClassName(stagedModel);
        long classPK = ExportImportClassedModelUtil.getClassPK(stagedModel);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(this.stagingGroup.getGroupId(), user.getUserId());
        CommentManagerUtil.addComment(user.getUserId(), this.stagingGroup.getGroupId(), className, classPK, user.getFullName(), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(50, new RandomizerBumper[0]), (Function<String, ServiceContext>)new IdentityServiceContextFunction(serviceContext));
    }

    protected Map<String, List<StagedModel>> addDefaultDependentStagedModelsMap(Group group) throws Exception {
        return new HashMap<String, List<StagedModel>>();
    }

    protected StagedModel addDefaultStagedModel(Group group, Map<String, List<StagedModel>> dependentStagedModelsMap) throws Exception {
        return null;
    }

    protected List<StagedModel> addDependentStagedModel(Map<String, List<StagedModel>> dependentStagedModelsMap, Class<?> clazz, StagedModel dependentStagedModel) {
        List<StagedModel> dependentStagedModels = dependentStagedModelsMap.get(clazz.getSimpleName());
        if (dependentStagedModels == null) {
            dependentStagedModels = new ArrayList<StagedModel>();
            dependentStagedModelsMap.put(clazz.getSimpleName(), dependentStagedModels);
        }
        dependentStagedModels.add(dependentStagedModel);
        return dependentStagedModels;
    }

    protected Map<String, List<StagedModel>> addDependentStagedModelsMap(Group group) throws Exception {
        return new HashMap<String, List<StagedModel>>();
    }

    protected void addRatings(StagedModel stagedModel) throws Exception {
        RatingsTestUtil.addEntry(stagedModel.getModelClassName(), ExportImportClassedModelUtil.getClassPK(stagedModel));
    }

    protected abstract StagedModel addStagedModel(Group var1, Map<String, List<StagedModel>> var2) throws Exception;

    protected StagedModel addVersion(StagedModel stagedModel) throws Exception {
        return null;
    }

    protected void deleteStagedModel(StagedModel stagedModel, Map<String, List<StagedModel>> dependentStagedModelsMap, Group group) throws Exception {
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(ExportImportClassedModelUtil.getClassName(stagedModel));
        stagedModelDataHandler.deleteStagedModel(stagedModel);
        for (List<StagedModel> dependentStagedModels : dependentStagedModelsMap.values()) {
            for (StagedModel dependentStagedModel : dependentStagedModels) {
                stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(ExportImportClassedModelUtil.getClassName(dependentStagedModel));
                stagedModelDataHandler.deleteStagedModel(dependentStagedModel);
            }
        }
    }

    protected void exportImportStagedModel(StagedModel stagedModel) throws Exception {
        this.initExport();
        StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedModel);
        this.initImport();
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull(exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel(this.portletDataContext, exportedStagedModel);
    }

    protected void exportImportStagedModelFromLiveToStaging(StagedModel stagedModel) throws Exception {
        this.initExport(this.liveGroup);
        StagedModelDataHandlerUtil.exportStagedModel(this.portletDataContext, stagedModel);
        this.initImport(this.liveGroup, this.stagingGroup);
        StagedModel exportedStagedModel = this.readExportedStagedModel(stagedModel);
        Assert.assertNotNull(exportedStagedModel);
        StagedModelDataHandlerUtil.importStagedModel(this.portletDataContext, exportedStagedModel);
    }

    protected AssetEntry fetchAssetEntry(StagedModel stagedModel, Group group) throws Exception {
        return AssetEntryLocalServiceUtil.fetchEntry(group.getGroupId(), stagedModel.getUuid());
    }

    protected Date getEndDate() {
        return new Date();
    }

    protected Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR_OVERWRITE"});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        return parameterMap;
    }

    protected abstract StagedModel getStagedModel(String var1, Group var2) throws PortalException;

    protected abstract Class<? extends StagedModel> getStagedModelClass();

    protected Date getStartDate() {
        return new Date(System.currentTimeMillis() - 3600000L);
    }

    protected void initExport() throws Exception {
        this.initExport(this.stagingGroup);
    }

    protected void initExport(Group exportGroup) throws Exception {
        this.zipWriter = ZipWriterFactoryUtil.getZipWriter();
        this.portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext(exportGroup.getCompanyId(), exportGroup.getGroupId(), this.getParameterMap(), this.getStartDate(), this.getEndDate(), this.zipWriter);
        this.portletDataContext.setExportImportProcessId(BaseStagedModelDataHandlerTestCase.class.getName());
        this.rootElement = SAXReaderUtil.createElement("root");
        this.portletDataContext.setExportDataRootElement(this.rootElement);
        this.missingReferencesElement = this.rootElement.addElement("missing-references");
        this.portletDataContext.setMissingReferencesElement(this.missingReferencesElement);
    }

    protected void initImport() throws Exception {
        this.initImport(this.stagingGroup, this.liveGroup);
    }

    protected void initImport(Group exportGroup, Group importGroup) throws Exception {
        this.userIdStrategy = new TestUserIdStrategy();
        this.zipReader = ZipReaderFactoryUtil.getZipReader(this.zipWriter.getFile());
        String xml = this.zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            Document document = SAXReaderUtil.createDocument();
            Element rootElement = document.addElement("root");
            rootElement.addElement("header");
            this.zipWriter.addEntry("/manifest.xml", document.asXML());
            this.zipReader = ZipReaderFactoryUtil.getZipReader(this.zipWriter.getFile());
        }
        this.portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext(importGroup.getCompanyId(), importGroup.getGroupId(), this.getParameterMap(), this.userIdStrategy, this.zipReader);
        this.portletDataContext.setExportImportProcessId(BaseStagedModelDataHandlerTestCase.class.getName());
        this.portletDataContext.setImportDataRootElement(this.rootElement);
        Element missingReferencesElement = this.rootElement.element("missing-references");
        if (missingReferencesElement == null) {
            missingReferencesElement = this.rootElement.addElement("missing-references");
        }
        this.portletDataContext.setMissingReferencesElement(missingReferencesElement);
        Group sourceCompanyGroup = GroupLocalServiceUtil.getCompanyGroup(exportGroup.getCompanyId());
        this.portletDataContext.setSourceCompanyGroupId(sourceCompanyGroup.getGroupId());
        this.portletDataContext.setSourceCompanyId(exportGroup.getCompanyId());
        this.portletDataContext.setSourceGroupId(exportGroup.getGroupId());
    }

    protected boolean isAssetPrioritySupported() {
        return false;
    }

    protected boolean isCommentableStagedModel() {
        return false;
    }

    protected boolean isVersionableStagedModel() {
        return false;
    }

    protected StagedModel readExportedStagedModel(StagedModel stagedModel) {
        String stagedModelPath = ExportImportPathUtil.getModelPath(stagedModel);
        return (StagedModel)this.portletDataContext.getZipEntryAsObject(stagedModelPath);
    }

    protected boolean supportLastPublishDateUpdate() {
        return false;
    }

    protected StagedModelAssets updateAssetEntry(StagedModel stagedModel, Group group) throws Exception {
        AssetEntry assetEntry = this.fetchAssetEntry(stagedModel, group);
        if (assetEntry == null) {
            return null;
        }
        AssetVocabulary assetVocabulary = AssetTestUtil.addVocabulary(this.stagingGroup.getGroupId());
        AssetCategory assetCategory = AssetTestUtil.addCategory(this.stagingGroup.getGroupId(), assetVocabulary.getVocabularyId());
        Company company = CompanyLocalServiceUtil.getCompany(stagedModel.getCompanyId());
        Group companyGroup = company.getGroup();
        AssetVocabulary companyAssetVocabulary = AssetTestUtil.addVocabulary(companyGroup.getGroupId());
        AssetCategory companyAssetCategory = AssetTestUtil.addCategory(companyGroup.getGroupId(), companyAssetVocabulary.getVocabularyId());
        AssetTag assetTag = AssetTestUtil.addTag(this.stagingGroup.getGroupId());
        double assetPriority = assetEntry.getPriority();
        if (this.isAssetPrioritySupported()) {
            assetPriority = RandomTestUtil.nextDouble();
        }
        assetEntry = AssetEntryLocalServiceUtil.updateEntry(TestPropsValues.getUserId(), this.stagingGroup.getGroupId(), assetEntry.getCreateDate(), assetEntry.getModifiedDate(), assetEntry.getClassName(), assetEntry.getClassPK(), assetEntry.getClassUuid(), assetEntry.getClassTypeId(), new long[]{assetCategory.getCategoryId(), companyAssetCategory.getCategoryId()}, new String[]{assetTag.getName()}, assetEntry.isListable(), assetEntry.isVisible(), assetEntry.getStartDate(), assetEntry.getEndDate(), assetEntry.getPublishDate(), assetEntry.getExpirationDate(), assetEntry.getMimeType(), assetEntry.getTitle(), assetEntry.getDescription(), assetEntry.getSummary(), assetEntry.getUrl(), assetEntry.getLayoutUuid(), assetEntry.getHeight(), assetEntry.getWidth(), assetPriority);
        return new StagedModelAssets(assetCategory, assetEntry, assetTag, assetVocabulary);
    }

    protected void validateAssets(StagedModel stagedModel, StagedModelAssets stagedModelAssets, Group group) throws Exception {
        if (stagedModelAssets == null) {
            return;
        }
        AssetEntry importedAssetEntry = this.fetchAssetEntry(stagedModel, group);
        if (this.isAssetPrioritySupported()) {
            AssetEntry assetEntry = stagedModelAssets.getAssetEntry();
            Assert.assertEquals(assetEntry.getPriority(), importedAssetEntry.getPriority(), 0.0);
        }
        List<AssetCategory> importedAssetCategories = AssetCategoryLocalServiceUtil.getEntryCategories(importedAssetEntry.getEntryId());
        Assert.assertEquals(importedAssetCategories.toString(), 2L, importedAssetCategories.size());
        AssetCategory stagedAssetCategory = stagedModelAssets.getAssetCategory();
        AssetCategoryModel importedAssetCategory = null;
        Company company = CompanyLocalServiceUtil.getCompany(group.getCompanyId());
        long companyGroupId = company.getGroupId();
        for (AssetCategory assetCategory : importedAssetCategories) {
            long groupId = assetCategory.getGroupId();
            if (groupId == companyGroupId) continue;
            importedAssetCategory = assetCategory;
            break;
        }
        Assert.assertEquals(stagedAssetCategory.getUuid(), importedAssetCategory.getUuid());
        List<AssetTag> importedAssetTags = AssetTagLocalServiceUtil.getEntryTags(importedAssetEntry.getEntryId());
        Assert.assertEquals(importedAssetTags.toString(), 1L, importedAssetTags.size());
        AssetTag assetTag = stagedModelAssets.getAssetTag();
        AssetTag importedAssetTag = importedAssetTags.get(0);
        Assert.assertEquals(assetTag.getName(), importedAssetTag.getName());
        AssetVocabulary assetVocabulary = stagedModelAssets.getAssetVocabulary();
        AssetVocabulary importedAssetVocabulary = AssetVocabularyLocalServiceUtil.getVocabulary(importedAssetCategory.getVocabularyId());
        Assert.assertEquals(assetVocabulary.getUuid(), importedAssetVocabulary.getUuid());
    }

    protected void validateComments(StagedModel stagedModel, StagedModel importedStagedModel, Group group) throws Exception {
        if (!this.isCommentableStagedModel()) {
            return;
        }
        List<MBMessage> discussionMBMessages = MBMessageLocalServiceUtil.getMessages(ExportImportClassedModelUtil.getClassName(stagedModel), ExportImportClassedModelUtil.getClassPK(stagedModel), -1);
        if (ListUtil.isEmpty(discussionMBMessages)) {
            return;
        }
        int importedDiscussionMBMessagesCount = MBMessageLocalServiceUtil.getDiscussionMessagesCount(ExportImportClassedModelUtil.getClassName(importedStagedModel), ExportImportClassedModelUtil.getClassPK(importedStagedModel), -1);
        Assert.assertEquals(discussionMBMessages.size(), importedDiscussionMBMessagesCount + 1);
        for (MBMessage discussionMBMessage : discussionMBMessages) {
            if (discussionMBMessage.isRoot()) continue;
            MBMessage importedDiscussionMBMessage = MBMessageLocalServiceUtil.fetchMBMessageByUuidAndGroupId(discussionMBMessage.getUuid(), group.getGroupId());
            Assert.assertNotNull(importedDiscussionMBMessage);
        }
    }

    protected void validateExport(PortletDataContext portletDataContext, StagedModel stagedModel, Map<String, List<StagedModel>> dependentStagedModelsMap) throws Exception {
        Element rootElement = portletDataContext.getExportDataRootElement();
        ArrayList<Element> stagedModelGroupElements = new ArrayList<Element>();
        Class<? extends StagedModel> stagedModelClass = this.getStagedModelClass();
        String stagedModelClassSimpleName = stagedModelClass.getSimpleName();
        stagedModelGroupElements.addAll(rootElement.elements(stagedModelClassSimpleName));
        for (String dependentStagedModelClassSimpleName : dependentStagedModelsMap.keySet()) {
            stagedModelGroupElements.addAll(rootElement.elements(dependentStagedModelClassSimpleName));
        }
        for (Element stagedModelGroupElement : stagedModelGroupElements) {
            String className = stagedModelGroupElement.getName();
            if (className.equals("missing-references")) continue;
            List<StagedModel> dependentStagedModels = dependentStagedModelsMap.get(className);
            dependentStagedModels = dependentStagedModels == null ? new ArrayList<StagedModel>() : ListUtil.copy(dependentStagedModels);
            if (className.equals(stagedModelClassSimpleName)) {
                dependentStagedModels.add(stagedModel);
            }
            List<Element> elements = stagedModelGroupElement.elements();
            Assert.assertEquals(elements.toString(), dependentStagedModels.size(), elements.size());
            for (Element element : elements) {
                String path = element.attributeValue("path");
                Assert.assertNotNull(path);
                Iterator<StagedModel> iterator = dependentStagedModels.iterator();
                while (iterator.hasNext()) {
                    StagedModel dependentStagedModel = iterator.next();
                    String dependentStagedModelPath = ExportImportPathUtil.getModelPath(dependentStagedModel);
                    if (!path.equals(dependentStagedModelPath)) continue;
                    iterator.remove();
                }
            }
            Assert.assertTrue("There is more than one element exported with the same path", dependentStagedModels.isEmpty());
        }
    }

    protected void validateImport(Map<String, List<StagedModel>> dependentStagedModelsMap, Group group) throws Exception {
    }

    protected void validateImport(StagedModel stagedModel, StagedModelAssets stagedModelAssets, Map<String, List<StagedModel>> dependentStagedModelsMap, Group group) throws Exception {
        StagedModel importedStagedModel = this.getStagedModel(stagedModel.getUuid(), group);
        Assert.assertNotNull(importedStagedModel);
        this.validateAssets(importedStagedModel, stagedModelAssets, group);
        this.validateComments(stagedModel, importedStagedModel, group);
        this.validateImport(dependentStagedModelsMap, group);
        this.validateImportedStagedModel(stagedModel, importedStagedModel);
        this.validateRatings(stagedModel, importedStagedModel);
    }

    protected void validateImportedStagedModel(StagedModel stagedModel, StagedModel importedStagedModel) throws Exception {
        Assert.assertTrue(stagedModel.getCreateDate() + " " + importedStagedModel.getCreateDate(), DateUtil.equals(stagedModel.getCreateDate(), importedStagedModel.getCreateDate()));
        Assert.assertTrue(stagedModel.getModifiedDate() + " " + importedStagedModel.getModifiedDate(), DateUtil.equals(stagedModel.getModifiedDate(), importedStagedModel.getModifiedDate()));
        Assert.assertEquals(stagedModel.getUuid(), importedStagedModel.getUuid());
    }

    protected void validateRatings(StagedModel stagedModel, StagedModel importedStagedModel) throws Exception {
        List<RatingsEntry> ratingsEntries = RatingsEntryLocalServiceUtil.getEntries(ExportImportClassedModelUtil.getClassName(stagedModel), ExportImportClassedModelUtil.getClassPK(stagedModel), -1.0);
        List<RatingsEntry> importedRatingsEntries = RatingsEntryLocalServiceUtil.getEntries(ExportImportClassedModelUtil.getClassName(importedStagedModel), ExportImportClassedModelUtil.getClassPK(importedStagedModel), -1.0);
        Assert.assertEquals(importedRatingsEntries.toString(), ratingsEntries.size(), importedRatingsEntries.size());
        block0: for (RatingsEntry ratingsEntry : ratingsEntries) {
            Iterator<RatingsEntry> iterator = importedRatingsEntries.iterator();
            while (iterator.hasNext()) {
                RatingsEntry importedRatingsEntry = iterator.next();
                if (ratingsEntry.getScore() != importedRatingsEntry.getScore()) continue;
                iterator.remove();
                continue block0;
            }
        }
        Assert.assertTrue(importedRatingsEntries.toString(), importedRatingsEntries.isEmpty());
    }

    protected class TestUserIdStrategy
    implements UserIdStrategy {
        private final long _userId;

        public TestUserIdStrategy() {
            this._userId = this._initializeUserId();
        }

        public TestUserIdStrategy(User user) {
            this._userId = user.getUserId();
        }

        @Override
        public long getUserId(String userUuid) {
            return this._userId;
        }

        private long _initializeUserId() {
            try {
                return TestPropsValues.getUserId();
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    protected class StagedModelAssets
    implements Serializable {
        private AssetCategory _assetCategory;
        private AssetEntry _assetEntry;
        private AssetTag _assetTag;
        private AssetVocabulary _assetVocabulary;

        public StagedModelAssets(AssetCategory assetCategory, AssetEntry assetEntry, AssetTag assetTag, AssetVocabulary assetVocabulary) {
            this._assetCategory = assetCategory;
            this._assetEntry = assetEntry;
            this._assetTag = assetTag;
            this._assetVocabulary = assetVocabulary;
        }

        public AssetCategory getAssetCategory() {
            return this._assetCategory;
        }

        public AssetEntry getAssetEntry() {
            return this._assetEntry;
        }

        public AssetTag getAssetTag() {
            return this._assetTag;
        }

        public AssetVocabulary getAssetVocabulary() {
            return this._assetVocabulary;
        }

        public void setAssetCategory(AssetCategory assetCategory) {
            this._assetCategory = assetCategory;
        }

        public void setAssetEntry(AssetEntry assetEntry) {
            this._assetEntry = assetEntry;
        }

        public void setAssetTag(AssetTag assetTag) {
            this._assetTag = assetTag;
        }

        public void setAssetVocabulary(AssetVocabulary assetVocabulary) {
            this._assetVocabulary = assetVocabulary;
        }
    }
}

