/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.test.util.model.DummyReference;
import com.liferay.portal.dao.orm.hibernate.DynamicQueryImpl;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.impl.CriteriaImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.exportimport.test.util.model.DummyReference"}, service={StagedModelRepository.class})
public class DummyReferenceStagedModelRepository
implements StagedModelRepository<DummyReference> {
    @Reference
    protected Portal portal;
    @Reference
    protected SystemEventLocalService systemEventLocalService;
    private final List<DummyReference> _dummyReferences = new ArrayList<DummyReference>();

    @Override
    public DummyReference addStagedModel(PortletDataContext portletDataContext, DummyReference dummyReference) throws PortalException {
        if (portletDataContext != null && portletDataContext.getUserIdStrategy() != null) {
            dummyReference.setUserId(portletDataContext.getUserId(dummyReference.getUserUuid()));
        }
        this._dummyReferences.add(dummyReference);
        return dummyReference;
    }

    @Override
    public void deleteStagedModel(DummyReference dummyReference) throws PortalException {
        if (this._dummyReferences.remove(dummyReference)) {
            this.systemEventLocalService.addSystemEvent(0L, dummyReference.getGroupId(), dummyReference.getModelClassName(), dummyReference.getPrimaryKey(), dummyReference.getUuid(), "", 1, "");
        }
    }

    @Override
    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._dummyReferences.removeIf(dummyReference -> Objects.equals(dummyReference.getUuid(), uuid) && dummyReference.getGroupId() == groupId);
    }

    @Override
    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._dummyReferences.clear();
    }

    @Override
    public DummyReference fetchMissingReference(String uuid, long groupId) {
        return this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    @Override
    public DummyReference fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        Stream dummyReferenceStream = this._dummyReferences.stream();
        List dummies = dummyReferenceStream.filter(dummyReference -> Objects.equals(dummyReference.getUuid(), uuid) && dummyReference.getGroupId() == groupId).collect(Collectors.toList());
        if (dummies.isEmpty()) {
            return null;
        }
        return (DummyReference)dummies.get(0);
    }

    @Override
    public List<DummyReference> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        Stream dummyReferenceStream = this._dummyReferences.stream();
        return dummyReferenceStream.filter(dummyReference -> Objects.equals(dummyReference.getUuid(), uuid) && dummyReference.getCompanyId() == companyId).collect(Collectors.toList());
    }

    @Override
    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            @Override
            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = DummyReferenceStagedModelRepository.this._dummyReferences.size();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                manifestSummary.addModelDeletionCount(stagedModelType, 0L);
                return modelAdditionCount;
            }

            @Override
            protected Projection getCountProjection() {
                return ProjectionFactoryUtil.countDistinct("resourcePrimKey");
            }
        };
        exportActionableDynamicQuery.setBaseLocalService(new DummyReferenceBaseLocalServiceImpl());
        Class<?> clazz = this.getClass();
        exportActionableDynamicQuery.setClassLoader(clazz.getClassLoader());
        exportActionableDynamicQuery.setModelClass(DummyReference.class);
        exportActionableDynamicQuery.setPrimaryKeyPropertyName("id");
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Disjunction disjunction;
            Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
            if (modifiedDateCriterion != null) {
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(modifiedDateCriterion);
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(RestrictionsFactoryUtil.gtProperty("modifiedDate", "lastPublishDate"));
                Property lastPublishDateProperty = PropertyFactoryUtil.forName("lastPublishDate");
                disjunction.add(lastPublishDateProperty.isNull());
                conjunction.add(disjunction);
                modifiedDateCriterion = conjunction;
            }
            Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
            if (modifiedDateCriterion != null && statusDateCriterion != null) {
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(modifiedDateCriterion);
                disjunction.add(statusDateCriterion);
                dynamicQuery.add(disjunction);
            }
            StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
            long referrerClassNameId = stagedModelType.getReferrerClassNameId();
            Property classNameIdProperty = PropertyFactoryUtil.forName("classNameId");
            if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                dynamicQuery.add(classNameIdProperty.eq(stagedModelType.getReferrerClassNameId()));
            } else if (referrerClassNameId == -2L) {
                dynamicQuery.add(classNameIdProperty.isNotNull());
            }
            Property workflowStatusProperty = PropertyFactoryUtil.forName("status");
            if (portletDataContext.isInitialPublication()) {
                dynamicQuery.add(workflowStatusProperty.ne(8));
            } else {
                StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(DummyReference.class.getName());
                dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod(dummyReference -> StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, dummyReference));
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(this.portal.getClassNameId(DummyReference.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    @Override
    public void restoreStagedModel(PortletDataContext portletDataContext, DummyReference stagedModel) throws PortletDataException {
    }

    @Override
    public DummyReference saveStagedModel(DummyReference dummyReference) throws PortalException {
        this.deleteStagedModel(dummyReference);
        this.addStagedModel((PortletDataContext)null, dummyReference);
        return dummyReference;
    }

    @Override
    public DummyReference updateStagedModel(PortletDataContext portletDataContext, DummyReference dummyReference) throws PortalException {
        DummyReference existingDummyReference = this._fetchDummyReference(dummyReference);
        existingDummyReference.setUserId(portletDataContext.getUserId(dummyReference.getUserUuid()));
        return dummyReference;
    }

    private DummyReference _fetchDummyReference(DummyReference dummyReference) throws NoSuchModelException {
        int i = this._dummyReferences.indexOf(dummyReference);
        if (i < 0) {
            throw new NoSuchModelException();
        }
        return this._dummyReferences.get(i);
    }

    public class DummyReferenceBaseLocalServiceImpl
    extends BaseLocalServiceImpl {
        public List<DummyReference> dynamicQuery(DynamicQuery dynamicQuery) {
            DetachedCriteria detachedCriteria = ((DynamicQueryImpl)dynamicQuery).getDetachedCriteria();
            Class<?> detachedCriteriaClass = detachedCriteria.getClass();
            List result = DummyReferenceStagedModelRepository.this._dummyReferences;
            try {
                Method method = detachedCriteriaClass.getDeclaredMethod("getCriteriaImpl", new Class[0]);
                method.setAccessible(true);
                CriteriaImpl detachedCriteriaImpl = (CriteriaImpl)method.invoke((Object)detachedCriteria, new Object[0]);
                Iterator iterator = detachedCriteriaImpl.iterateExpressionEntries();
                while (iterator.hasNext()) {
                    CriteriaImpl.CriterionEntry criteriaImpl = (CriteriaImpl.CriterionEntry)iterator.next();
                    Stream dummyReferenceStream = result.stream();
                    result = dummyReferenceStream.filter(this.getPredicate(criteriaImpl.toString())).collect(Collectors.toList());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
            return DummyReferenceStagedModelRepository.this._dummyReferences.size();
        }

        public Predicate<? super DummyReference> getPredicate(String expression) {
            if (expression.contains("groupId=")) {
                return d -> d.getGroupId() == Long.valueOf(expression.substring("groupId=".length())).longValue();
            }
            if (expression.contains("id>-1")) {
                return d -> d.getId() > -1L;
            }
            if (expression.contains("companyId=")) {
                return d -> d.getCompanyId() == Long.valueOf(expression.substring("companyId=".length())).longValue();
            }
            return d -> true;
        }

        @Override
        protected ClassLoader getClassLoader() {
            return super.getClassLoader();
        }

        @Override
        protected Map<Locale, String> getLocalizationMap(String value) {
            return super.getLocalizationMap(value);
        }
    }
}

