/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.changeset;

import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Changeset
implements Serializable {
    private Map<Supplier<? extends StagedModel>, Function<StagedModel, Collection<?>>> _hierarchySuppliers;
    private List<Supplier<Collection<? extends StagedModel>>> _multiSuppliers;
    private boolean _rawMode;
    private List<StagedModel> _rawModels;
    private List<Supplier<StagedModel>> _suppliers;
    private String _uuid = PortalUUIDUtil.generate();

    public static Builder create() {
        return new Builder(new Changeset());
    }

    public static RawBuilder createRaw() {
        return new RawBuilder(new Changeset());
    }

    public String getUuid() {
        return this._uuid;
    }

    public Stream<StagedModel> stream() {
        if (this._rawMode) {
            return this._rawModels.stream();
        }
        Stream multiSupplierStream = this._multiSuppliers.stream();
        List multiStagedModels = multiSupplierStream.flatMap(s -> {
            Collection collection = (Collection)s.get();
            return collection.stream();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Stream supplierStream = this._suppliers.stream();
        List stagedModels = supplierStream.map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<StagedModel> hierarchyStagedModels = new ArrayList<StagedModel>();
        for (Map.Entry<Supplier<StagedModel>, Function<StagedModel, Collection<?>>> entry : this._hierarchySuppliers.entrySet()) {
            Supplier<? extends StagedModel> supplier = entry.getKey();
            StagedModel stagedModel = supplier.get();
            String stagedModelClassName = ExportImportClassedModelUtil.getClassName(stagedModel);
            hierarchyStagedModels.addAll(this._getChildrenStagedModels(stagedModel, stagedModelClassName, entry.getValue()));
        }
        return Stream.concat(hierarchyStagedModels.stream(), Stream.concat(stagedModels.stream(), multiStagedModels.stream()));
    }

    private Changeset() {
    }

    private List<StagedModel> _getChildrenStagedModels(StagedModel parentStagedModel, String parentClassName, Function<StagedModel, Collection<?>> hierarchyFunction) {
        ArrayList<StagedModel> stagedModels = new ArrayList<StagedModel>();
        for (Object object : hierarchyFunction.apply(parentStagedModel)) {
            StagedModel stagedModel = (StagedModel)object;
            String stagedModelClassName = stagedModel.getModelClassName();
            if (stagedModelClassName.equals(parentClassName)) {
                stagedModels.addAll(this._getChildrenStagedModels(stagedModel, parentClassName, hierarchyFunction));
            }
            stagedModels.add(stagedModel);
        }
        return stagedModels;
    }

    public static class RawBuilder {
        private final Changeset _changeset;

        public RawBuilder(Changeset changeset) {
            this._changeset = changeset;
            this._changeset._rawMode = true;
            this._changeset._rawModels = new ArrayList();
        }

        public RawBuilder addMultipleStagedModel(Collection<? extends StagedModel> stagedModels) {
            Stream<? extends StagedModel> stream = stagedModels.stream();
            stream.filter(Objects::nonNull).forEach(stagedModel -> this._changeset._rawModels.add(stagedModel));
            return this;
        }

        public RawBuilder addStagedModel(StagedModel stagedModel) {
            this._changeset._rawModels.add(stagedModel);
            return this;
        }

        public Changeset build() {
            return this._changeset;
        }
    }

    public static class Builder {
        private final Changeset _changeset;

        public Builder(Changeset changeset) {
            this._changeset = changeset;
            this._changeset._hierarchySuppliers = new HashMap();
            this._changeset._multiSuppliers = new ArrayList();
            this._changeset._rawMode = false;
            this._changeset._suppliers = new ArrayList();
        }

        public Builder addModel(Supplier<ClassedModel> supplier, Function<ClassedModel, StagedModel> adapterFunction) {
            Supplier<StagedModel> stagedModelSupplier = () -> {
                ClassedModel classedModel = (ClassedModel)supplier.get();
                return (StagedModel)adapterFunction.apply(classedModel);
            };
            this._changeset._suppliers.add(stagedModelSupplier);
            return this;
        }

        public Builder addMultipleStagedModel(Supplier<Collection<? extends StagedModel>> supplier) {
            this._changeset._multiSuppliers.add(supplier);
            return this;
        }

        public Builder addStagedModel(Supplier<StagedModel> supplier) {
            this._changeset._suppliers.add(supplier);
            return this;
        }

        public <T extends StagedModel> Builder addStagedModelHierarchy(Supplier<T> supplier, Function<T, Collection<?>> hierarchyFunction) {
            Function<T, Collection<?>> function = hierarchyFunction;
            this._changeset._hierarchySuppliers.put(supplier, function);
            return this;
        }

        public Changeset build() {
            return this._changeset;
        }
    }
}

