/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.taglib.servlet.taglib;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.permission.ExpandoColumnPermissionUtil;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.TagSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class CustomAttributesAvailableTag
extends TagSupport {
    private String _className;
    private long _classPK;
    private long _companyId;
    private boolean _editable;
    private String _ignoreAttributeNames;

    @Override
    public int doStartTag() throws JspException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long companyId = this._companyId;
            if (companyId == 0L) {
                companyId = themeDisplay.getCompanyId();
            }
            ExpandoBridge expandoBridge = null;
            expandoBridge = this._classPK == 0L ? ExpandoBridgeFactoryUtil.getExpandoBridge(companyId, this._className) : ExpandoBridgeFactoryUtil.getExpandoBridge(companyId, this._className, this._classPK);
            ArrayList<String> attributeNames = Collections.list(expandoBridge.getAttributeNames());
            for (String ignoreAttributeName : StringUtil.split(this._ignoreAttributeNames, ',')) {
                attributeNames.remove(ignoreAttributeName);
            }
            if (attributeNames.isEmpty()) {
                int n = 0;
                return n;
            }
            if (this._classPK == 0L) {
                int n = 1;
                return n;
            }
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            for (String attributeName : attributeNames) {
                Serializable value = expandoBridge.getAttribute(attributeName);
                if (Validator.isNull(value)) continue;
                UnicodeProperties properties = expandoBridge.getAttributeProperties(attributeName);
                boolean propertyHidden = GetterUtil.getBoolean((String)properties.get("hidden"));
                boolean propertyVisibleWithUpdatePermission = GetterUtil.getBoolean((String)properties.get("visible-with-update-permission"));
                if (this._editable && propertyVisibleWithUpdatePermission) {
                    propertyHidden = !ExpandoColumnPermissionUtil.contains(permissionChecker, companyId, this._className, "CUSTOM_FIELDS", attributeName, "UPDATE");
                }
                if (propertyHidden || !ExpandoColumnPermissionUtil.contains(permissionChecker, companyId, this._className, "CUSTOM_FIELDS", attributeName, "VIEW")) continue;
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (!ServerDetector.isResin()) {
                this._className = null;
                this._classPK = 0L;
                this._companyId = 0L;
                this._editable = false;
                this._ignoreAttributeNames = null;
            }
        }
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public void setIgnoreAttributeNames(String ignoreAttributeNames) {
        this._ignoreAttributeNames = ignoreAttributeNames;
    }
}

