/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import java.util.Locale;

public class HTMLSanitizerDDMFormFieldValueTransformer
implements DDMFormFieldValueTransformer {
    private final long _companyId;
    private final long _groupId;
    private final long _userId;

    public HTMLSanitizerDDMFormFieldValueTransformer(long companyId, long groupId, long userId) {
        this._companyId = companyId;
        this._groupId = groupId;
        this._userId = userId;
    }

    @Override
    public String getFieldType() {
        return "ddm-text-html";
    }

    @Override
    public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        for (Locale locale : value.getAvailableLocales()) {
            String sanitizedValue = this.sanitize(value.getString(locale));
            value.addString(locale, sanitizedValue);
        }
    }

    protected String sanitize(String value) throws PortalException {
        return SanitizerUtil.sanitize(this._companyId, this._groupId, this._userId, Value.class.getName(), 0L, "text/html", "ALL", value, null);
    }
}

