/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.annotations.DDMFormLayout;
import com.liferay.dynamic.data.mapping.annotations.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.annotations.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class DDMFormLayoutFactoryHelper {
    private final Class<?> _clazz;
    private final DDMFormLayout _ddmFormLayout;
    private Locale _defaultLocale;

    public DDMFormLayoutFactoryHelper(Class<?> clazz) {
        this._clazz = clazz;
        this._ddmFormLayout = clazz.getAnnotation(DDMFormLayout.class);
        this.setDefaultLocale();
    }

    public com.liferay.dynamic.data.mapping.model.DDMFormLayout createDDMFormLayout() {
        com.liferay.dynamic.data.mapping.model.DDMFormLayout ddmFormLayout = new com.liferay.dynamic.data.mapping.model.DDMFormLayout();
        ddmFormLayout.setDefaultLocale(this._defaultLocale);
        ddmFormLayout.setPaginationMode(this._ddmFormLayout.paginationMode());
        for (DDMFormLayoutPage ddmFormLayoutPage : this._ddmFormLayout.value()) {
            ddmFormLayout.addDDMFormLayoutPage(this.createDDMFormLayoutPage(ddmFormLayoutPage));
        }
        return ddmFormLayout;
    }

    protected void collectResourceBundles(Class<?> clazz, List<ResourceBundle> resourceBundles, Locale locale) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            this.collectResourceBundles(interfaceClass, resourceBundles, locale);
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle("content.Language", locale, clazz.getClassLoader());
        if (resourceBundle != null) {
            resourceBundles.add(resourceBundle);
        }
    }

    protected DDMFormLayoutColumn createDDMFormLayoutColumn(com.liferay.dynamic.data.mapping.annotations.DDMFormLayoutColumn ddmFormLayoutColumnAnnotation) {
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn();
        ddmFormLayoutColumn.setDDMFormFieldNames(ListUtil.fromArray(ddmFormLayoutColumnAnnotation.value()));
        ddmFormLayoutColumn.setSize(ddmFormLayoutColumnAnnotation.size());
        return ddmFormLayoutColumn;
    }

    protected com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage createDDMFormLayoutPage(DDMFormLayoutPage ddmFormLayoutPageAnnotation) {
        com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage ddmFormLayoutPage = new com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage();
        LocalizedValue title = this.createDDMFormLayoutPageTitle(ddmFormLayoutPageAnnotation.title());
        ddmFormLayoutPage.setTitle(title);
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPageAnnotation.value()) {
            ddmFormLayoutPage.addDDMFormLayoutRow(this.createDDMFormLayoutRow(ddmFormLayoutRow));
        }
        return ddmFormLayoutPage;
    }

    protected LocalizedValue createDDMFormLayoutPageTitle(String title) {
        LocalizedValue localizedValue = new LocalizedValue(this._defaultLocale);
        if (Validator.isNull(title)) {
            return localizedValue;
        }
        if (this.isLocalizableValue(title)) {
            String languageKey = this.extractLanguageKey(title);
            localizedValue.addString(this._defaultLocale, this.getLocalizedValue(this._defaultLocale, languageKey));
        } else {
            localizedValue.addString(this._defaultLocale, title);
        }
        return localizedValue;
    }

    protected com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow createDDMFormLayoutRow(DDMFormLayoutRow ddmFormLayoutRowAnnotation) {
        com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow ddmFormLayoutRow = new com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow();
        for (com.liferay.dynamic.data.mapping.annotations.DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRowAnnotation.value()) {
            ddmFormLayoutRow.addDDMFormLayoutColumn(this.createDDMFormLayoutColumn(ddmFormLayoutColumn));
        }
        return ddmFormLayoutRow;
    }

    protected String extractLanguageKey(String value) {
        return StringUtil.extractLast(value, "%");
    }

    protected LocalizedValue getDDMFormLayoutPageTitle(String title) {
        Locale defaultLocale = LocaleUtil.getDefault();
        LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
        if (Validator.isNull(title)) {
            return localizedValue;
        }
        if (this.isLocalizableValue(title)) {
            String languageKey = this.extractLanguageKey(title);
            localizedValue.addString(defaultLocale, this.getLocalizedValue(defaultLocale, languageKey));
        } else {
            localizedValue.addString(defaultLocale, title);
        }
        return localizedValue;
    }

    protected String getLocalizedValue(Locale locale, String value) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        return LanguageUtil.get(resourceBundle, value);
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        ResourceBundle portalResourceBundle = PortalUtil.getResourceBundle(locale);
        resourceBundles.add(portalResourceBundle);
        this.collectResourceBundles(this._clazz, resourceBundles, locale);
        ResourceBundle[] resourceBundlesArray = resourceBundles.toArray(new ResourceBundle[0]);
        return new AggregateResourceBundle(resourceBundlesArray);
    }

    protected boolean isLocalizableValue(String value) {
        return StringUtil.startsWith(value, "%");
    }

    protected void setDefaultLocale() {
        Locale defaultLocale = LocaleThreadLocal.getThemeDisplayLocale();
        if (defaultLocale == null) {
            defaultLocale = LocaleUtil.getDefault();
        }
        this._defaultLocale = defaultLocale;
    }
}

