/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.annotations.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormFactoryHelper;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldFactoryHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DDMFormInstanceFactory {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceFactory.class);

    public static <T> T create(Class<T> clazz, DDMFormValues ddmFormValues) {
        return DDMFormInstanceFactory.create(clazz, ddmFormValues, ddmFormValues.getDefaultLocale());
    }

    public static <T> T create(Class<T> clazz, DDMFormValues ddmFormValues, Locale locale) {
        Object proxy = ProxyUtil.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new DDMFormInstanceInvocationHandler<T>(clazz, ddmFormValues, locale));
        return clazz.cast(proxy);
    }

    private static class DDMFormInstanceInvocationHandler<T>
    implements InvocationHandler {
        private final DDMFormFactoryHelper _ddmFormFactoryHelper;
        private final Map<String, List<DDMFormFieldValue>> _ddmFormFieldValuesMap;
        private final DDMFormValues _ddmFormValues;
        private final Locale _locale;

        public DDMFormInstanceInvocationHandler(Class<T> clazz, DDMFormValues ddmFormValues, Locale locale) {
            this._ddmFormFactoryHelper = new DDMFormFactoryHelper(clazz);
            this._ddmFormValues = ddmFormValues;
            this._locale = locale;
            this._ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!method.isAnnotationPresent(DDMFormField.class)) {
                return null;
            }
            DDMFormFieldFactoryHelper ddmFormFieldFactoryHelper = new DDMFormFieldFactoryHelper(this._ddmFormFactoryHelper, method);
            List<DDMFormFieldValue> ddmFormFieldValues = this._ddmFormFieldValuesMap.get(ddmFormFieldFactoryHelper.getDDMFormFieldName());
            if (ListUtil.isEmpty(ddmFormFieldValues)) {
                LocalizedValue predefinedValue = ddmFormFieldFactoryHelper.getDDMFormFieldPredefinedValue();
                return this.convert(method.getReturnType(), ddmFormFieldFactoryHelper.getDDMFormFieldType(), predefinedValue.getString(this._locale));
            }
            return this.convert(method.getReturnType(), ddmFormFieldFactoryHelper.getDDMFormFieldType(), ddmFormFieldValues);
        }

        protected Object convert(Class<?> returnType, String ddmFormFieldType, List<DDMFormFieldValue> ddmFormFieldValues) {
            if (returnType.isArray()) {
                return this.toArray(returnType.getComponentType(), ddmFormFieldType, ddmFormFieldValues);
            }
            return this.toPrimitive(returnType, ddmFormFieldType, ddmFormFieldValues.get(0));
        }

        protected Object convert(Class<?> returnType, String ddmFormFieldType, String predefinedValue) {
            if (returnType.isArray()) {
                return Array.newInstance(returnType.getComponentType(), 0);
            }
            if (returnType == Boolean.TYPE || returnType == Boolean.class) {
                return GetterUtil.getBoolean(predefinedValue);
            }
            if (returnType == Double.TYPE || returnType == Double.class) {
                return GetterUtil.getDouble(predefinedValue);
            }
            if (returnType == Float.TYPE || returnType == Float.class) {
                return Float.valueOf(GetterUtil.getFloat(predefinedValue));
            }
            if (returnType == Integer.TYPE || returnType == Integer.class) {
                return GetterUtil.getInteger(predefinedValue);
            }
            if (returnType == Long.TYPE || returnType == Long.class) {
                return GetterUtil.getLong(predefinedValue);
            }
            if (returnType == Short.TYPE || returnType == Short.class) {
                return GetterUtil.getShort(predefinedValue);
            }
            if (returnType == String.class && Validator.isNotNull(predefinedValue)) {
                return this.toString(ddmFormFieldType, predefinedValue);
            }
            return null;
        }

        protected String joinJSONArrayString(String valueString) {
            if (Validator.isNull(valueString)) {
                return valueString;
            }
            try {
                JSONArray jsonArray = JSONFactoryUtil.createJSONArray(valueString);
                StringBundler sb = new StringBundler(jsonArray.length() * 2);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    sb.append(jsonArray.getString(i));
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.setIndex(sb.index() - 1);
                }
                return sb.toString();
            }
            catch (JSONException jsone) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to parse JSON", jsone);
                }
                return valueString;
            }
        }

        protected Object toArray(Class<?> returnType, String ddmFormFieldType, List<DDMFormFieldValue> ddmFormFieldValues) {
            Object array = Array.newInstance(returnType, ddmFormFieldValues.size());
            int i = 0;
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                Array.set(array, i++, this.toPrimitive(returnType, ddmFormFieldType, ddmFormFieldValue));
            }
            return array;
        }

        protected boolean toBoolean(Value value) {
            return Boolean.valueOf(value.getString(this._locale));
        }

        protected double toDouble(Value value) {
            return Double.valueOf(value.getString(this._locale));
        }

        protected Object toDynamicForm(Class<?> clazz, DDMFormFieldValue ddmFormFieldValue) {
            DDMFormValues ddmFormValues = new DDMFormValues(DDMFormFactory.create(clazz));
            ddmFormValues.setAvailableLocales(this._ddmFormValues.getAvailableLocales());
            ddmFormValues.setDefaultLocale(this._ddmFormValues.getDefaultLocale());
            ddmFormValues.setDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues());
            Object proxy = ProxyUtil.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new DDMFormInstanceInvocationHandler(clazz, ddmFormValues, this._locale));
            return clazz.cast(proxy);
        }

        protected float toFloat(Value value) {
            return Float.valueOf(value.getString(this._locale)).floatValue();
        }

        protected int toInteger(Value value) {
            return Integer.valueOf(value.getString(this._locale));
        }

        protected long toLong(Value value) {
            return Long.valueOf(value.getString(this._locale));
        }

        protected Object toPrimitive(Class<?> returnType, String ddmFormFieldType, DDMFormFieldValue ddmFormFieldValue) {
            Value value = ddmFormFieldValue.getValue();
            if (returnType == Boolean.TYPE || returnType == Boolean.class) {
                return this.toBoolean(value);
            }
            if (returnType == Double.TYPE || returnType == Double.class) {
                return this.toDouble(value);
            }
            if (returnType == Float.TYPE || returnType == Float.class) {
                return Float.valueOf(this.toFloat(value));
            }
            if (returnType == Integer.TYPE || returnType == Integer.class) {
                return this.toInteger(value);
            }
            if (returnType == Long.TYPE || returnType == Long.class) {
                return this.toLong(value);
            }
            if (returnType == Short.TYPE || returnType == Short.class) {
                return this.toShort(value);
            }
            if (returnType == String.class) {
                return this.toString(ddmFormFieldType, value.getString(this._locale));
            }
            return this.toDynamicForm(returnType, ddmFormFieldValue);
        }

        protected short toShort(Value value) {
            return Short.valueOf(value.getString(this._locale));
        }

        protected String toString(String ddmFormFieldType, String valueString) {
            if (Objects.equals(ddmFormFieldType, "select")) {
                return this.joinJSONArrayString(valueString);
            }
            return valueString;
        }
    }
}

