/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.test.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMStructureTestUtil {
    public static DDMStructure addStructure(long groupId, String className) throws Exception {
        return DDMStructureTestUtil.addStructure(groupId, className, 0L, DDMStructureTestUtil.getSampleDDMForm(), LocaleUtil.getSiteDefault(), ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(long groupId, String className, DDMForm ddmForm) throws Exception {
        return DDMStructureTestUtil.addStructure(groupId, className, 0L, ddmForm, LocaleUtil.getSiteDefault(), ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(long groupId, String className, DDMForm ddmForm, Locale defaultLocale) throws Exception {
        return DDMStructureTestUtil.addStructure(groupId, className, 0L, ddmForm, defaultLocale, ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(long groupId, String className, Locale defaultLocale) throws Exception {
        return DDMStructureTestUtil.addStructure(groupId, className, 0L, DDMStructureTestUtil.getSampleDDMForm(), defaultLocale, ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(long groupId, String className, long parentStructureId) throws Exception {
        return DDMStructureTestUtil.addStructure(groupId, className, parentStructureId, DDMStructureTestUtil.getSampleDDMForm(), LocaleUtil.getSiteDefault(), ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(long groupId, String className, long parentStructureId, DDMForm ddmForm, Locale defaultLocale, ServiceContext serviceContext) throws Exception {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(defaultLocale, "Test Structure");
        DDMFormLayout ddmFormLayout = DDMUtil.getDefaultDDMFormLayout(ddmForm);
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return DDMStructureLocalServiceUtil.addStructure(TestPropsValues.getUserId(), groupId, parentStructureId, PortalUtil.getClassNameId(className), null, nameMap, null, ddmForm, ddmFormLayout, StorageType.JSON.toString(), 0, serviceContext);
    }

    public static DDMStructure addStructure(String className) throws Exception {
        return DDMStructureTestUtil.addStructure(TestPropsValues.getGroupId(), className, 0L, DDMStructureTestUtil.getSampleDDMForm(), LocaleUtil.getSiteDefault(), ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(String className, DDMForm ddmForm) throws Exception {
        return DDMStructureTestUtil.addStructure(TestPropsValues.getGroupId(), className, 0L, ddmForm, LocaleUtil.getSiteDefault(), ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(String className, DDMForm ddmForm, Locale defaultLocale) throws Exception {
        return DDMStructureTestUtil.addStructure(TestPropsValues.getGroupId(), className, 0L, ddmForm, defaultLocale, ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(String className, Locale defaultLocale) throws Exception {
        return DDMStructureTestUtil.addStructure(TestPropsValues.getGroupId(), className, 0L, DDMStructureTestUtil.getSampleDDMForm("name", new Locale[]{LocaleUtil.US}, defaultLocale), defaultLocale, ServiceContextTestUtil.getServiceContext());
    }

    public static DDMStructure addStructure(String className, Locale[] availableLocales, Locale defaultLocale) throws Exception {
        return DDMStructureTestUtil.addStructure(TestPropsValues.getGroupId(), className, 0L, DDMStructureTestUtil.getSampleDDMForm("name", availableLocales, defaultLocale), defaultLocale, ServiceContextTestUtil.getServiceContext());
    }

    public static DDMForm getSampleDDMForm() {
        return DDMStructureTestUtil.getSampleDDMForm("name");
    }

    public static DDMForm getSampleDDMForm(Locale[] availableLocales, Locale defaultLocale) {
        return DDMStructureTestUtil.getSampleDDMForm("name", availableLocales, defaultLocale);
    }

    public static DDMForm getSampleDDMForm(String name) {
        return DDMStructureTestUtil.getSampleDDMForm(name, new Locale[]{LocaleUtil.US}, LocaleUtil.US);
    }

    public static DDMForm getSampleDDMForm(String name, Locale[] availableLocales, Locale defaultLocale) {
        return DDMStructureTestUtil.getSampleDDMForm(name, "string", "text", true, "text", availableLocales, defaultLocale);
    }

    public static DDMForm getSampleDDMForm(String name, String dataType, String indexType, boolean repeatable, String type, Locale[] availableLocales, Locale defaultLocale) {
        DDMForm ddmForm = new DDMForm();
        Set<Locale> availableLocalesSet = SetUtil.fromArray(availableLocales);
        ddmForm.setAvailableLocales(availableLocalesSet);
        ddmForm.setDefaultLocale(defaultLocale);
        DDMFormField ddmFormField = new DDMFormField(name, type);
        ddmFormField.setDataType(dataType);
        ddmFormField.setIndexType(indexType);
        ddmFormField.setLocalizable(true);
        ddmFormField.setRepeatable(repeatable);
        LocalizedValue label = new LocalizedValue(defaultLocale);
        label.addString(defaultLocale, "Field_" + LocaleUtil.toLanguageId(defaultLocale));
        for (Locale locale : availableLocalesSet) {
            label.addString(locale, "Field_" + LocaleUtil.toLanguageId(locale));
        }
        ddmFormField.setLabel(label);
        ddmForm.addDDMFormField(ddmFormField);
        return ddmForm;
    }

    public static String getSampleStructuredContent() {
        return DDMStructureTestUtil.getSampleStructuredContent("name", "title");
    }

    public static String getSampleStructuredContent(Map<Locale, String> contents, String defaultLocale) {
        return DDMStructureTestUtil.getSampleStructuredContent("name", Collections.singletonList(contents), defaultLocale);
    }

    public static String getSampleStructuredContent(String keywords) {
        return DDMStructureTestUtil.getSampleStructuredContent("name", keywords);
    }

    public static String getSampleStructuredContent(String name, List<Map<Locale, String>> contents, String defaultLocale) {
        StringBundler sb = new StringBundler();
        for (Map<Locale, String> map : contents) {
            for (Locale locale : map.keySet()) {
                sb.append(LocaleUtil.toLanguageId(locale));
                sb.append(",");
            }
            sb.setIndex(sb.index() - 1);
        }
        Document document = DDMStructureTestUtil.createDocumentContent(sb.toString(), defaultLocale);
        Element rootElement = document.getRootElement();
        for (Map map : contents) {
            Element dynamicElementElement = rootElement.addElement("dynamic-element");
            dynamicElementElement.addAttribute("index-type", "keyword");
            dynamicElementElement.addAttribute("name", name);
            dynamicElementElement.addAttribute("type", "text");
            for (Map.Entry entry : map.entrySet()) {
                Element element = dynamicElementElement.addElement("dynamic-content");
                element.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)entry.getKey()));
                element.addCDATA((String)entry.getValue());
            }
        }
        return document.asXML();
    }

    public static String getSampleStructuredContent(String name, String keywords) {
        HashMap<Locale, String> contents = new HashMap<Locale, String>();
        contents.put(LocaleUtil.US, keywords);
        return DDMStructureTestUtil.getSampleStructuredContent(name, Collections.singletonList(contents), "en_US");
    }

    public static Map<String, Map<String, String>> getXSDMap(String xsd) throws Exception {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        Document document = UnsecureSAXReaderUtil.read(xsd);
        XPath xPathSelector = SAXReaderUtil.createXPath("//dynamic-element");
        List<Node> nodes = xPathSelector.selectNodes(document);
        for (Node node : nodes) {
            Element dynamicElementElement = (Element)node;
            String elementName = DDMStructureTestUtil.getElementName(dynamicElementElement);
            map.put(elementName, DDMStructureTestUtil.getElementMap(dynamicElementElement));
        }
        return map;
    }

    protected static Document createDocumentContent(String availableLocales, String defaultLocale) {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        rootElement.addAttribute("available-locales", availableLocales);
        rootElement.addAttribute("default-locale", defaultLocale);
        rootElement.addElement("request");
        return document;
    }

    protected static Document createDocumentStructure(Locale[] availableLocales, Locale defaultLocale) {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        rootElement.addAttribute("available-locales", StringUtil.merge(LocaleUtil.toLanguageIds(availableLocales)));
        rootElement.addAttribute("default-locale", LocaleUtil.toLanguageId(defaultLocale));
        return document;
    }

    protected static Map<String, String> getElementMap(Element element) {
        HashMap<String, String> elementMap = new HashMap<String, String>();
        for (Attribute attribute : element.attributes()) {
            elementMap.put(attribute.getName(), attribute.getValue());
        }
        for (Element metadadataElement : element.elements("meta-data")) {
            String metadataLanguageId = metadadataElement.attributeValue("locale");
            for (Element entryElement : metadadataElement.elements("entry")) {
                String entryName = entryElement.attributeValue("name");
                elementMap.put(entryName.concat(metadataLanguageId), entryElement.getText());
            }
        }
        return elementMap;
    }

    protected static String getElementName(Element element) {
        String parentName;
        StringBuilder sb = new StringBuilder();
        sb.append(element.attributeValue("name"));
        for (Element parentElement = element.getParent(); parentElement != null && !(parentName = parentElement.getName()).equals("root"); parentElement = parentElement.getParent()) {
            sb.insert(0, parentElement.attributeValue("name") + "/");
        }
        String type = element.attributeValue("type");
        if (Objects.equals(type, "option")) {
            sb.append("/");
            sb.append(element.attributeValue("value"));
        }
        return sb.toString();
    }
}

