/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.template;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.template.TemplateVariableCodeHandler;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Set;

public class DDMTemplateVariableCodeHandler
implements TemplateVariableCodeHandler {
    private final ClassLoader _classLoader;
    private final Set<String> _templateNames;
    private final String _templatePath;

    public DDMTemplateVariableCodeHandler(ClassLoader classLoader, String templatePath, Set<String> templateNames) {
        this._classLoader = classLoader;
        this._templatePath = templatePath;
        this._templateNames = templateNames;
    }

    @Override
    public String[] generate(TemplateVariableDefinition templateVariableDefinition, String language) throws Exception {
        String templateId = this.getTemplateId(templateVariableDefinition.getDataType());
        Template template = this.getTemplate(templateId);
        String content = this.getTemplateContent(template, templateVariableDefinition, language);
        if (templateVariableDefinition.isRepeatable()) {
            content = this.handleRepeatableField(templateVariableDefinition, language, content);
        }
        return new String[]{content};
    }

    protected Template getTemplate(String templateId) throws Exception {
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource("ftl", StringBundler.concat(ClassLoaderPool.getContextName(this._classLoader), "_CLASS_LOADER_CONTEXT_", templateId));
        return TemplateManagerUtil.getTemplate("ftl", templateResource, false);
    }

    protected String getTemplateContent(Template template, TemplateVariableDefinition templateVariableDefinition, String language) throws Exception {
        this.prepareTemplate(template, templateVariableDefinition, language);
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate(writer);
        return StringUtil.trim(((Object)writer).toString());
    }

    protected String getTemplateId(String dataType) {
        if (!this._templateNames.contains(dataType)) {
            dataType = "common";
        }
        return this.getTemplatePath() + dataType + ".ftl";
    }

    protected String getTemplatePath() {
        return this._templatePath;
    }

    protected String handleRepeatableField(TemplateVariableDefinition templateVariableDefinition, String language, String templateContent) throws Exception {
        Template template = this.getTemplate(this.getTemplatePath() + "repeatable.ftl");
        templateContent = StringUtil.replace(templateContent, '\n', "\n\t\t");
        template.put("templateContent", templateContent);
        return this.getTemplateContent(template, templateVariableDefinition, language);
    }

    protected void prepareTemplate(Template template, TemplateVariableDefinition templateVariableDefinition, String language) {
        template.put("dataType", templateVariableDefinition.getDataType());
        template.put("help", templateVariableDefinition.getHelp());
        template.put("label", templateVariableDefinition.getLabel());
        template.put("language", language);
        template.put("name", templateVariableDefinition.getName());
        template.put("repeatable", templateVariableDefinition.isRepeatable());
    }
}

