/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.taglib.servlet.taglib;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.taglib.internal.servlet.ServletContextUtil;
import com.liferay.dynamic.data.mapping.taglib.servlet.taglib.base.BaseHTMLTag;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class HTMLTag
extends BaseHTMLTag {
    private static final Log _log = LogFactoryUtil.getLog(HTMLTag.class);

    @Override
    public int doStartTag() throws JspException {
        DDMFormValues ddmFormValues;
        if (!this.getIgnoreRequestValue() && (ddmFormValues = this.getDDMFormValuesFromRequest()) != null) {
            this.setDdmFormValues(ddmFormValues);
        }
        return super.doStartTag();
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.setServletContext(ServletContextUtil.getServletContext());
    }

    protected DDMForm getDDMForm() {
        try {
            return DDMUtil.getDDMForm(this.getClassNameId(), this.getClassPK());
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(this.getLogMessage(), pe);
            }
            return null;
        }
    }

    protected DDMFormValues getDDMFormValuesFromRequest() {
        block3: {
            String serializedDDMFormValues = ParamUtil.getString(this.request, this.getDDMFormValuesInputName());
            if (Validator.isNotNull(serializedDDMFormValues)) {
                DDMForm ddmForm = this.getDDMForm();
                try {
                    return DDMUtil.getDDMFormValues(ddmForm, serializedDDMFormValues);
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug(pe, pe);
                }
            }
        }
        return null;
    }

    protected String getDDMFormValuesInputName() {
        String fieldsNamespace = GetterUtil.getString(this.getFieldsNamespace());
        return fieldsNamespace + "ddmFormValues";
    }

    protected Fields getFields() {
        block4: {
            try {
                long ddmStructureId = this.getClassPK();
                if (this.getClassNameId() == PortalUtil.getClassNameId(DDMTemplate.class)) {
                    DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate(this.getClassPK());
                    ddmStructureId = ddmTemplate.getClassPK();
                }
                if (this.getDdmFormValues() != null) {
                    return DDMUtil.getFields(ddmStructureId, this.getDdmFormValues());
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn(this.getLogMessage(), pe);
            }
        }
        return null;
    }

    protected String getLogMessage() {
        if (this.getClassNameId() == PortalUtil.getClassNameId(DDMTemplate.class)) {
            return "Unable to retrieve DDM template with class PK " + this.getClassPK();
        }
        return "Unable to retrieve DDM structure with class PK " + this.getClassPK();
    }

    protected String getMode() {
        if (this.getClassNameId() != PortalUtil.getClassNameId(DDMTemplate.class)) {
            return null;
        }
        try {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate(this.getClassPK());
            return ddmTemplate.getMode();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(this.getLogMessage(), pe);
            }
            return null;
        }
    }

    @Deprecated
    protected String getRandomNamespace() {
        return PortalUtil.generateRandomKey(this.request, "taglib_ddm_init-ext");
    }

    @Override
    protected int processEndTag() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.write("</div>");
        return 6;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        super.setAttributes(httpServletRequest);
        this.setNamespacedAttribute(httpServletRequest, "ddmForm", this.getDDMForm());
        this.setNamespacedAttribute(httpServletRequest, "ddmFormValuesInputName", this.getDDMFormValuesInputName());
        this.setNamespacedAttribute(httpServletRequest, "fields", this.getFields());
        if (this.getGroupId() <= 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this.setNamespacedAttribute(httpServletRequest, "groupId", String.valueOf(themeDisplay.getSiteGroupId()));
        }
        this.setNamespacedAttribute(httpServletRequest, "mode", this.getMode());
        this.setNamespacedAttribute(httpServletRequest, "randomNamespace", this.getRandomNamespace());
    }
}

