/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.field.type;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.Validator;
import java.net.URL;
import java.util.Locale;

public abstract class BaseDDMFormFieldRenderer
implements DDMFormFieldRenderer {
    public abstract String getTemplateLanguage();

    public abstract String getTemplateNamespace();

    public abstract TemplateResource getTemplateResource();

    @Override
    public String render(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws PortalException {
        Template template = TemplateManagerUtil.getTemplate(this.getTemplateLanguage(), this.getTemplateResource(), false);
        template.put("namespace", this.getTemplateNamespace());
        template.put("render_strict", Boolean.FALSE);
        this.populateRequiredContext(template, ddmFormField, ddmFormFieldRenderingContext);
        this.populateOptionalContext(template, ddmFormField, ddmFormFieldRenderingContext);
        return this.render(template);
    }

    protected TemplateResource getTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    protected String getValueString(Value value, Locale locale) {
        if (value != null) {
            return value.getString(locale);
        }
        return "";
    }

    protected void populateOptionalContext(Template template, DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
    }

    protected void populateRequiredContext(Template template, DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        Locale locale = ddmFormFieldRenderingContext.getLocale();
        String childElementsHTML = ddmFormFieldRenderingContext.getChildElementsHTML();
        if (Validator.isNotNull(childElementsHTML)) {
            template.put("childElementsHTML", childElementsHTML);
        }
        template.put("dir", LanguageUtil.get(locale, "lang.dir"));
        template.put("label", ddmFormFieldRenderingContext.getLabel());
        template.put("name", ddmFormFieldRenderingContext.getName());
        template.put("readOnly", this._isReadOnly(ddmFormField, ddmFormFieldRenderingContext));
        template.put("required", ddmFormFieldRenderingContext.isRequired());
        template.put("showLabel", ddmFormField.isShowLabel());
        template.put("tip", ddmFormFieldRenderingContext.getTip());
        template.put("value", ddmFormFieldRenderingContext.getValue());
        template.put("visible", ddmFormFieldRenderingContext.isVisible());
    }

    protected String render(Template template) throws PortalException {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate(writer);
        return ((Object)writer).toString();
    }

    private boolean _isReadOnly(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        return ddmFormFieldRenderingContext.isReadOnly() || ddmFormField.isReadOnly();
    }
}

