/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.test.util.search;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;

public class DLFolderSearchFixture {
    protected DLAppLocalService dlAppLocalService;
    protected DLFileEntryLocalService dlFileEntryLocalService;
    protected DLFolderLocalService dlFolderLocalService;
    private final List<DLFolder> _dlFolders = new ArrayList<DLFolder>();

    public DLFolderSearchFixture(DLAppLocalService dlAppLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFolderLocalService dlFolderLocalService) {
        this.dlAppLocalService = dlAppLocalService;
        this.dlFileEntryLocalService = dlFileEntryLocalService;
        this.dlFolderLocalService = dlFolderLocalService;
    }

    public DLFolder addDLFolderAndDLFileEntry(Group group, User user, String keywords, String content, ServiceContext serviceContext) throws Exception {
        DLFolder dlFolder = this.dlFolderLocalService.addFolder(user.getUserId(), group.getGroupId(), group.getGroupId(), false, 0L, keywords, keywords, false, serviceContext);
        this.dlFileEntryLocalService.addFileEntry(user.getUserId(), group.getGroupId(), group.getGroupId(), dlFolder.getFolderId(), keywords, null, RandomTestUtil.randomString(new RandomizerBumper[0]), keywords, "", 0L, null, null, new ByteArrayInputStream(content.getBytes()), 0L, serviceContext);
        this._dlFolders.add(dlFolder);
        return dlFolder;
    }

    public DLFolder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws Exception {
        Folder folder = this.dlAppLocalService.addFolder(serviceContext.getUserId(), serviceContext.getScopeGroupId(), parentFolderId, name, description, serviceContext);
        DLFolder dlFolder = (DLFolder)folder.getModel();
        this._dlFolders.add(dlFolder);
        return dlFolder;
    }

    public List<DLFolder> getDLFolders() {
        return this._dlFolders;
    }

    public void setUp() {
    }

    public void tearDown() throws Exception {
        for (DLFolder folder : this._dlFolders) {
            this.dlFolderLocalService.deleteAllByRepository(folder.getRepositoryId());
        }
    }
}

