/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.model;

import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public abstract class ExtRepositoryModelAdapter<T>
implements Cloneable,
RepositoryModel<T> {
    private final ExtRepositoryAdapter _extRepositoryAdapter;
    private final ExtRepositoryModel _extRepositoryModel;
    private final long _extRepositoryObjectId;
    private final String _uuid;

    public T clone() {
        try {
            return (T)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public long getCompanyId() {
        return this._extRepositoryAdapter.getCompanyId();
    }

    @Override
    public Date getCreateDate() {
        return this._extRepositoryModel.getCreateDate();
    }

    public String getDescription() {
        return "";
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(this.getCompanyId(), this.getModelClassName(), this.getPrimaryKey());
    }

    public ExtRepositoryModel getExtRepositoryModel() {
        return this._extRepositoryModel;
    }

    @Override
    public long getGroupId() {
        return this._extRepositoryAdapter.getGroupId();
    }

    @Override
    public Date getLastPublishDate() {
        return null;
    }

    @Override
    public Object getModel() {
        return this._extRepositoryModel;
    }

    @Override
    public String getModelClassName() {
        Class<?> modelClass = this.getModelClass();
        return modelClass.getName();
    }

    @Override
    public long getPrimaryKey() {
        return this._extRepositoryObjectId;
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getRepositoryId() {
        return this._extRepositoryAdapter.getRepositoryId();
    }

    public long getSize() {
        return this._extRepositoryModel.getSize();
    }

    @Override
    public long getUserId() {
        User user = this.getUser(this._extRepositoryModel.getOwner());
        return user.getUserId();
    }

    @Override
    public String getUserName() {
        User user = this.getUser(this._extRepositoryModel.getOwner());
        return user.getFullName();
    }

    @Override
    public String getUserUuid() {
        User user = this.getUser(this._extRepositoryModel.getOwner());
        try {
            return user.getUserUuid();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getUuid() {
        return this._uuid;
    }

    public boolean isDefaultRepository() {
        return false;
    }

    @Override
    public boolean isEscapedModel() {
        return false;
    }

    @Override
    public void setCompanyId(long companyId) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setCreateDate(Date date) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setGroupId(long groupId) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setLastPublishDate(Date lastPublishDate) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setUserId(long userId) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setUserName(String userName) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setUserUuid(String userUuid) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public void setUuid(String uuid) {
        throw new UnsupportedOperationException("Model is read only");
    }

    @Override
    public T toEscapedModel() {
        return (T)this;
    }

    @Override
    public T toUnescapedModel() {
        return (T)this;
    }

    protected ExtRepositoryModelAdapter(ExtRepositoryAdapter extRepositoryAdapter, long extRepositoryObjectId, String uuid, ExtRepositoryModel extRepositoryModel) {
        this._extRepositoryAdapter = extRepositoryAdapter;
        this._extRepositoryObjectId = extRepositoryObjectId;
        this._uuid = uuid;
        this._extRepositoryModel = extRepositoryModel;
    }

    protected ExtRepositoryAdapter getRepository() {
        return this._extRepositoryAdapter;
    }

    protected User getUser(String extRepositoryUserName) {
        User user = null;
        if (Validator.isNotNull(extRepositoryUserName)) {
            String liferayLogin = this._extRepositoryAdapter.getLiferayLogin(extRepositoryUserName);
            try {
                String authType = this._extRepositoryAdapter.getAuthType();
                if (authType.equals("userId")) {
                    user = UserLocalServiceUtil.getUser(GetterUtil.getLong(liferayLogin));
                } else if (authType.equals("emailAddress")) {
                    user = UserLocalServiceUtil.getUserByEmailAddress(this.getCompanyId(), liferayLogin);
                } else if (authType.equals("screenName")) {
                    user = UserLocalServiceUtil.getUserByScreenName(this.getCompanyId(), liferayLogin);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (user == null) {
            try {
                user = UserLocalServiceUtil.getDefaultUser(this.getCompanyId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return user;
    }
}

