/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.model;

import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryFolder;
import com.liferay.document.library.repository.external.model.ExtRepositoryObjectAdapter;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import java.util.Date;

public class ExtRepositoryFolderAdapter
extends ExtRepositoryObjectAdapter<Folder>
implements Folder {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryFolderAdapter.class);
    private final ExtRepositoryFolder _extRepositoryFolder;

    public ExtRepositoryFolderAdapter(ExtRepositoryAdapter extRepositoryAdapter, long extRepositoryObjectId, String uuid, ExtRepositoryFolder extRepositoryFolder) {
        super(extRepositoryAdapter, extRepositoryObjectId, uuid, extRepositoryFolder);
        this._extRepositoryFolder = extRepositoryFolder;
    }

    @Override
    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute(this);
    }

    @Override
    public ExtRepositoryFolder getExtRepositoryModel() {
        return this._extRepositoryFolder;
    }

    @Override
    public long getFolderId() {
        return this.getPrimaryKey();
    }

    @Override
    public Date getLastPostDate() {
        return this.getModifiedDate();
    }

    @Override
    public Class<?> getModelClass() {
        return Folder.class;
    }

    @Override
    public String getName() {
        if (this.isRoot()) {
            try {
                Folder folder = DLAppLocalServiceUtil.getMountFolder(this.getRepositoryId());
                return folder.getName();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return this._extRepositoryFolder.getName();
    }

    @Override
    public long getParentFolderId() {
        try {
            Folder parentFolder = this.getParentFolder();
            if (parentFolder != null) {
                return parentFolder.getFolderId();
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return 0L;
    }

    @Override
    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return repository.getCapability(capabilityClass);
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFolderConstants.getClassName());
    }

    @Override
    public boolean hasInheritableLock() {
        return false;
    }

    @Override
    public boolean hasLock() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean isMountPoint() {
        return false;
    }

    @Override
    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    @Override
    public boolean isRoot() {
        return this._extRepositoryFolder.isRoot();
    }

    @Override
    public boolean isSupportsLocking() {
        return false;
    }

    @Override
    public boolean isSupportsMultipleUpload() {
        return false;
    }

    @Override
    public boolean isSupportsShortcuts() {
        return false;
    }

    @Override
    public boolean isSupportsSubscribing() {
        return false;
    }

    private Repository _getRepository() {
        try {
            return RepositoryProviderUtil.getRepository(this.getRepositoryId());
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to get repository for folder " + this.getFolderId(), pe);
        }
    }
}

