/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.model;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.model.ExtRepositoryFileVersionAdapter;
import com.liferay.document.library.repository.external.model.ExtRepositoryObjectAdapter;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

public class ExtRepositoryFileEntryAdapter
extends ExtRepositoryObjectAdapter<FileEntry>
implements FileEntry {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryFileEntryAdapter.class);
    private final ExtRepositoryFileEntry _extRepositoryFileEntry;

    public ExtRepositoryFileEntryAdapter(ExtRepositoryAdapter extRepositoryAdapter, long extRepositoryObjectId, String uuid, ExtRepositoryFileEntry extRepositoryFileEntry) {
        super(extRepositoryAdapter, extRepositoryObjectId, uuid, extRepositoryFileEntry);
        this._extRepositoryFileEntry = extRepositoryFileEntry;
    }

    @Override
    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute(this);
    }

    @Override
    public InputStream getContentStream() throws PortalException {
        ExtRepositoryAdapter extRepositoryAdapter = this.getRepository();
        return extRepositoryAdapter.getContentStream(this);
    }

    @Override
    public InputStream getContentStream(String version) throws PortalException {
        ExtRepositoryAdapter extRepositoryAdapter = this.getRepository();
        FileVersion fileVersion = this.getFileVersion(version);
        return extRepositoryAdapter.getContentStream((ExtRepositoryFileVersionAdapter)fileVersion);
    }

    @Override
    public ExtRepositoryFileEntry getExtRepositoryModel() {
        return this._extRepositoryFileEntry;
    }

    @Override
    public long getFileEntryId() {
        return this.getPrimaryKey();
    }

    @Override
    public String getFileName() {
        return DLUtil.getSanitizedFileName(this.getTitle(), this.getExtension());
    }

    @Override
    public List<FileShortcut> getFileShortcuts() {
        return Collections.emptyList();
    }

    @Override
    public FileVersion getFileVersion() {
        try {
            List<ExtRepositoryFileVersionAdapter> extRepositoryFileVersionAdapters = this._getExtRepositoryFileVersionAdapters();
            return extRepositoryFileVersionAdapters.get(0);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public FileVersion getFileVersion(String version) throws PortalException {
        List<ExtRepositoryFileVersionAdapter> extRepositoryFileVersionAdapters = this._getExtRepositoryFileVersionAdapters();
        for (ExtRepositoryFileVersionAdapter extRepositoryFileVersionAdapter : extRepositoryFileVersionAdapters) {
            String curVersion = extRepositoryFileVersionAdapter.getVersion();
            if (!curVersion.equals(version)) continue;
            return extRepositoryFileVersionAdapter;
        }
        throw new NoSuchFileVersionException(StringBundler.concat("No file version with {fileEntryId=", this.getFileEntryId(), ", version: ", version, "}"));
    }

    @Override
    public List<FileVersion> getFileVersions(int status) {
        if (status == -1 || status == 0) {
            try {
                return this._getExtRepositoryFileVersionAdapters();
            }
            catch (PortalException pe) {
                throw new SystemException(pe);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getFileVersionsCount(int status) {
        List<FileVersion> fileVersions = this.getFileVersions(status);
        return fileVersions.size();
    }

    @Override
    public Folder getFolder() {
        Folder parentFolder = null;
        try {
            parentFolder = this.getParentFolder();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return parentFolder;
    }

    @Override
    public long getFolderId() {
        Folder folder = this.getFolder();
        return folder.getFolderId();
    }

    @Override
    public String getIcon() {
        return DLUtil.getFileIcon(this.getExtension());
    }

    @Override
    public String getIconCssClass() {
        return DLUtil.getFileIconCssClass(this.getExtension());
    }

    @Override
    public FileVersion getLatestFileVersion() throws PortalException {
        return this.getFileVersion();
    }

    @Override
    public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
        return this.getFileVersion();
    }

    @Override
    public Lock getLock() {
        if (!this.isCheckedOut()) {
            return null;
        }
        String checkedOutBy = this._extRepositoryFileEntry.getCheckedOutBy();
        User user = this.getUser(checkedOutBy);
        long userId = 0L;
        String userName = null;
        if (user != null) {
            userId = user.getUserId();
            userName = user.getFullName();
        }
        return LockManagerUtil.createLock(0L, this.getCompanyId(), userId, userName);
    }

    @Override
    public String getMimeType() {
        String mimeType = this._extRepositoryFileEntry.getMimeType();
        if (Validator.isNull(mimeType)) {
            mimeType = MimeTypesUtil.getContentType(this.getTitle());
        }
        return mimeType;
    }

    @Override
    public String getMimeType(String version) {
        String mimeType;
        FileVersion fileVersion;
        block5: {
            fileVersion = null;
            try {
                fileVersion = this.getFileVersion(version);
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn(StringBundler.concat("Unable to obtain version ", version, " for external ", "repository file entry ", this.getTitle()), pe);
                }
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn(StringBundler.concat("Unable to obtain version ", version, " for external ", "repository file entry ", this.getTitle()), se);
            }
        }
        if (fileVersion != null && Validator.isNotNull(mimeType = fileVersion.getMimeType())) {
            return mimeType;
        }
        return MimeTypesUtil.getContentType(this.getTitle());
    }

    @Override
    public Class<?> getModelClass() {
        return FileEntry.class;
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    @Override
    public int getReadCount() {
        return 0;
    }

    @Override
    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        ExtRepositoryAdapter repository = this.getRepository();
        return repository.getCapability(capabilityClass);
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    @Override
    public String getTitle() {
        return this._extRepositoryFileEntry.getTitle();
    }

    @Override
    public String getVersion() {
        try {
            List<ExtRepositoryFileVersionAdapter> extRepositoryFileVersionAdapters = this._getExtRepositoryFileVersionAdapters();
            FileVersion fileVersion = extRepositoryFileVersionAdapters.get(0);
            return fileVersion.getVersion();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public long getVersionUserId() {
        return this.getUserId();
    }

    @Override
    public String getVersionUserName() {
        return this.getUserName();
    }

    @Override
    public String getVersionUserUuid() {
        return this.getUserUuid();
    }

    @Override
    public boolean hasLock() {
        if (!this.isCheckedOut()) {
            return false;
        }
        User checkedOutByUser = this.getUser(this._extRepositoryFileEntry.getCheckedOutBy());
        return checkedOutByUser.getUserId() == PrincipalThreadLocal.getUserId();
    }

    @Override
    public boolean isCheckedOut() {
        return !Validator.isNull(this._extRepositoryFileEntry.getCheckedOutBy());
    }

    @Override
    public boolean isManualCheckInRequired() {
        return true;
    }

    @Override
    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        ExtRepositoryAdapter repository = this.getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    @Override
    public boolean isSupportsLocking() {
        return true;
    }

    private List<ExtRepositoryFileVersionAdapter> _getExtRepositoryFileVersionAdapters() throws PortalException {
        ExtRepositoryAdapter extRepositoryAdapter = this.getRepository();
        return extRepositoryAdapter.getExtRepositoryFileVersionAdapters(this);
    }
}

