/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external;

import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.search.ExtRepositoryQueryMapper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class ExtRepositoryQueryMapperImpl
implements ExtRepositoryQueryMapper {
    private static final String _INDEX_DATE_FORMAT_PATTERN = PropsUtil.get("index.date.format.pattern");
    private final ExtRepositoryAdapter _extRepositoryAdapter;

    public ExtRepositoryQueryMapperImpl(ExtRepositoryAdapter extRepositoryAdapter) {
        this._extRepositoryAdapter = extRepositoryAdapter;
    }

    @Override
    public Date formatDateParameterValue(String fieldName, String fieldValue) throws SearchException {
        if (fieldName.equals("createDate") || fieldName.equals("modified")) {
            try {
                DateFormat searchSimpleDateFormat = DateFormatFactoryUtil.getSimpleDateFormat(_INDEX_DATE_FORMAT_PATTERN);
                return searchSimpleDateFormat.parse(fieldValue);
            }
            catch (ParseException pe) {
                throw new SearchException(StringBundler.concat("Unable to parse date ", fieldValue, " for field ", fieldName), pe);
            }
        }
        throw new SearchException("Field " + fieldName + " is not a date");
    }

    @Override
    public String formatParameterValue(String fieldName, String fieldValue) throws SearchException {
        if (fieldName.equals("createDate") || fieldName.equals("modified")) {
            throw new SearchException("Use the method formatDateParameterValue to format the date field " + fieldName);
        }
        if (fieldName.equals("folderId")) {
            try {
                long folderId = GetterUtil.getLong(fieldValue);
                return this._extRepositoryAdapter.getExtRepositoryObjectKey(folderId);
            }
            catch (PortalException pe) {
                throw new SearchException("Unable to get folder folder " + fieldValue, pe);
            }
            catch (SystemException se) {
                throw new SearchException("Unable to get folder folder " + fieldValue, se);
            }
        }
        if (fieldName.equals("userId")) {
            try {
                long userId = GetterUtil.getLong(fieldValue);
                User user = UserLocalServiceUtil.getUserById(userId);
                return user.getScreenName();
            }
            catch (Exception e) {
                throw new SearchException("Unable to get user user " + fieldValue, e);
            }
        }
        return fieldValue;
    }
}

