/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.digital.signature.model;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DSSessionKey {
    private final String _accountKey;
    private final long _companyId;
    private final String _userName;

    public DSSessionKey(String dsSessionKeyString) {
        List<String> dsSessionKeyTokens = StringUtil.split(dsSessionKeyString, '_');
        if (dsSessionKeyTokens.size() != 3) {
            throw new IllegalArgumentException("Digital signature session key does not match format ${accountKey}_${companyId}_${userName}: " + dsSessionKeyString);
        }
        this._accountKey = dsSessionKeyTokens.get(0);
        this._companyId = GetterUtil.getLong(dsSessionKeyTokens.get(1));
        this._userName = dsSessionKeyTokens.get(2);
    }

    public DSSessionKey(String accountKey, long companyId, String userName) {
        this._accountKey = accountKey;
        this._companyId = companyId;
        this._userName = userName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DSSessionKey)) {
            return false;
        }
        DSSessionKey dsSessionKey = (DSSessionKey)object;
        return Objects.equals(this._accountKey, dsSessionKey._accountKey) && Objects.equals(this._companyId, dsSessionKey._companyId) && Objects.equals(this._userName, dsSessionKey._userName);
    }

    public String getAccountKey() {
        return this._accountKey;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getUserName() {
        return this._userName;
    }

    public int hashCode() {
        return Objects.hash(this._accountKey, this._companyId, this._userName);
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append(this._accountKey);
        sb.append("_");
        sb.append(this._companyId);
        sb.append("_");
        sb.append(this._userName);
        return sb.toString();
    }
}

