/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.currency.converter.util;

import com.liferay.currency.converter.model.CurrencyConverter;
import com.liferay.currency.converter.util.CurrencyConverterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Objects;

public class CurrencyConverterWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 1200000L;
    private static final String _SYMBOL_EURO = "EUR";
    private final String _symbol;

    public CurrencyConverterWebCacheItem(String symbol) {
        this._symbol = symbol;
    }

    @Override
    public Object convert(String key) throws WebCacheException {
        String symbol = this._symbol;
        double rate = 0.0;
        try {
            if (symbol.length() != 6) {
                throw new WebCacheException(symbol);
            }
            String fromSymbol = symbol.substring(0, 3);
            String toSymbol = symbol.substring(3, 6);
            if (!CurrencyConverterUtil.isCurrency(fromSymbol) || !CurrencyConverterUtil.isCurrency(toSymbol)) {
                throw new WebCacheException(symbol);
            }
            String text = HttpUtil.URLtoString("http://www.ecb.int/stats/eurofxref/eurofxref-daily.xml");
            Document document = SAXReaderUtil.read(text);
            Element rootElement = document.getRootElement();
            String fromRate = this._getRate(fromSymbol, rootElement);
            String toRate = this._getRate(toSymbol, rootElement);
            rate = GetterUtil.getDouble(toRate) / GetterUtil.getDouble(fromRate);
        }
        catch (Exception e) {
            throw new WebCacheException(e);
        }
        return new CurrencyConverter(symbol, rate);
    }

    @Override
    public long getRefreshTime() {
        return 1200000L;
    }

    private String _getRate(String symbol, Element element) {
        if (symbol.equals(_SYMBOL_EURO)) {
            return "1.0";
        }
        String rate = null;
        for (Element cubeElement : element.elements("Cube")) {
            if (Objects.equals(cubeElement.attributeValue("currency"), symbol)) {
                return cubeElement.attributeValue("rate");
            }
            rate = this._getRate(symbol, cubeElement);
        }
        return rate;
    }
}

