/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.currency.converter.util;

import com.liferay.currency.converter.model.CurrencyConverter;
import com.liferay.currency.converter.util.CurrencyConverterWebCacheItem;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class CurrencyConverterUtil {
    private static final CurrencyConverterUtil _instance = new CurrencyConverterUtil();
    private static final Map<String, Map<String, String>> _symbolsPool = new ConcurrentHashMap<String, Map<String, String>>();
    private final Set<String> _currencyIds = new HashSet<String>();

    public static Map<String, String> getAllSymbols(Locale locale) {
        String key = locale.toString();
        Map<String, String> symbols = _symbolsPool.get(key);
        if (symbols != null) {
            return symbols;
        }
        symbols = new TreeMap<String, String>();
        for (String symbol : CurrencyConverterUtil._instance._currencyIds) {
            symbols.put(LanguageUtil.get(locale, symbol), symbol);
        }
        _symbolsPool.put(key, symbols);
        return symbols;
    }

    public static CurrencyConverter getCurrencyConverter(String symbol) {
        CurrencyConverterWebCacheItem wci = new CurrencyConverterWebCacheItem(symbol);
        String key = CurrencyConverterUtil.class.getName() + "." + symbol;
        try {
            return (CurrencyConverter)WebCachePoolUtil.get(key, wci);
        }
        catch (ClassCastException cce) {
            WebCachePoolUtil.remove(key);
            return null;
        }
    }

    public static boolean isCurrency(String symbol) {
        return CurrencyConverterUtil._instance._currencyIds.contains(symbol);
    }

    private CurrencyConverterUtil() {
        this._currencyIds.add("AUD");
        this._currencyIds.add("BGN");
        this._currencyIds.add("BRL");
        this._currencyIds.add("CAD");
        this._currencyIds.add("CHF");
        this._currencyIds.add("CNY");
        this._currencyIds.add("CZK");
        this._currencyIds.add("DKK");
        this._currencyIds.add("EUR");
        this._currencyIds.add("GBP");
        this._currencyIds.add("HKD");
        this._currencyIds.add("HRK");
        this._currencyIds.add("HUF");
        this._currencyIds.add("IDR");
        this._currencyIds.add("ILS");
        this._currencyIds.add("INR");
        this._currencyIds.add("ISK");
        this._currencyIds.add("JPY");
        this._currencyIds.add("KRW");
        this._currencyIds.add("MXN");
        this._currencyIds.add("MYR");
        this._currencyIds.add("NOK");
        this._currencyIds.add("NZD");
        this._currencyIds.add("PHP");
        this._currencyIds.add("PLN");
        this._currencyIds.add("RON");
        this._currencyIds.add("RUB");
        this._currencyIds.add("SEK");
        this._currencyIds.add("SGD");
        this._currencyIds.add("THB");
        this._currencyIds.add("TRY");
        this._currencyIds.add("USD");
        this._currencyIds.add("ZAR");
    }
}

