/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.util;

import com.liferay.contacts.model.Entry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.kernel.service.ListTypeServiceUtil;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.service.WebsiteLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.service.SocialRelationLocalServiceUtil;
import com.liferay.social.kernel.service.SocialRequestLocalServiceUtil;
import java.lang.reflect.Field;
import java.util.List;

public class ContactsUtil {
    public static JSONObject getEntryJSONObject(Entry entry) {
        return JSONUtil.put("comments", (Object)entry.getComments()).put("emailAddress", entry.getEmailAddress()).put("entryId", String.valueOf(entry.getEntryId())).put("fullName", entry.getFullName()).put("portalUser", false);
    }

    public static long getGroupId(String filterBy) {
        String groupIdString = filterBy.substring("group_".length());
        return GetterUtil.getLong(groupIdString);
    }

    public static String[] getPortalPropsValue(String key) {
        try {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            Class<?> targetClass = portalClassLoader.loadClass("com.liferay.portal.util.PropsValues");
            Field field = targetClass.getField(key);
            return (String[])field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long getSocialRelationType(String filterBy) {
        String socialRelationTypeString = filterBy.substring("type_".length());
        return GetterUtil.getLong(socialRelationTypeString);
    }

    public static JSONObject getUserJSONObject(long userId, User user) throws PortalException {
        boolean block = SocialRelationLocalServiceUtil.hasRelation(userId, user.getUserId(), 9);
        JSONObject jsonObject = JSONUtil.put("block", (Object)block).put("contactId", String.valueOf(user.getContactId())).put("emailAddress", user.getEmailAddress()).put("firstName", user.getFirstName()).put("fullName", user.getFullName()).put("jobTitle", user.getJobTitle()).put("lastName", user.getLastName()).put("portalUser", true).put("portraitId", String.valueOf(user.getPortraitId())).put("userId", String.valueOf(user.getUserId())).put("uuid", user.getUuid());
        if (!SocialRelationLocalServiceUtil.hasRelation(user.getUserId(), userId, 9) && !SocialRelationLocalServiceUtil.hasRelation(userId, user.getUserId(), 9)) {
            boolean connectionRequested = SocialRequestLocalServiceUtil.hasRequest(userId, User.class.getName(), userId, 12, user.getUserId(), 3);
            jsonObject.put("connectionRequested", connectionRequested);
            boolean connected = false;
            if (!connectionRequested && SocialRelationLocalServiceUtil.hasRelation(userId, user.getUserId(), 12)) {
                connected = true;
            }
            jsonObject.put("connected", connected);
            boolean following = SocialRelationLocalServiceUtil.hasRelation(userId, user.getUserId(), 8);
            jsonObject.put("following", following);
        }
        return jsonObject;
    }

    public static String getVCard(User user) throws Exception {
        StringBundler sb = new StringBundler(9);
        sb.append(ContactsUtil._getHeader());
        Contact contact = user.getContact();
        sb.append(ContactsUtil._getName(user, contact));
        sb.append(ContactsUtil._getJobTitle(user));
        sb.append(ContactsUtil._getEmailAddresses(user));
        sb.append(ContactsUtil._getPhones(user));
        sb.append(ContactsUtil._getAddresses(user));
        sb.append(ContactsUtil._getWebsites(user));
        sb.append(ContactsUtil._getInstantMessaging(contact));
        sb.append(ContactsUtil._getFooter());
        return sb.toString();
    }

    public static String getVCards(List<User> users) throws Exception {
        StringBundler sb = new StringBundler(users.size());
        for (User user : users) {
            sb.append(ContactsUtil.getVCard(user));
        }
        return sb.toString();
    }

    private static String _getAddresses(User user) throws Exception {
        List<Address> addresses = AddressLocalServiceUtil.getAddresses(user.getCompanyId(), Contact.class.getName(), user.getContactId());
        StringBundler sb = new StringBundler(addresses.size() * 19);
        for (Address address : addresses) {
            sb.append("ADR;TYPE=");
            ListType listType = address.getType();
            sb.append(StringUtil.toUpperCase(ContactsUtil._getVCardListTypeName(listType)));
            sb.append(":");
            sb.append(";");
            sb.append(";");
            if (Validator.isNotNull(address.getStreet1())) {
                sb.append(address.getStreet1());
            }
            if (Validator.isNotNull(address.getStreet2())) {
                sb.append("\\n");
                sb.append(address.getStreet2());
            }
            if (Validator.isNotNull(address.getStreet3())) {
                sb.append("\\n");
                sb.append(address.getStreet3());
            }
            sb.append(";");
            if (Validator.isNotNull(address.getCity())) {
                sb.append(address.getCity());
            }
            sb.append(";");
            long regionId = address.getRegionId();
            if (regionId > 0L) {
                Region region = RegionServiceUtil.getRegion(regionId);
                sb.append(region.getName());
            }
            sb.append(";");
            if (Validator.isNotNull(address.getZip())) {
                sb.append(address.getZip());
            }
            sb.append(";");
            long countryId = address.getCountryId();
            if (countryId > 0L) {
                Country country = CountryServiceUtil.getCountry(countryId);
                sb.append(country.getName());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String _getEmailAddresses(User user) throws Exception {
        List<EmailAddress> emailAddresses = EmailAddressLocalServiceUtil.getEmailAddresses(user.getCompanyId(), Contact.class.getName(), user.getContactId());
        StringBundler sb = new StringBundler(3 + emailAddresses.size() * 5);
        sb.append("EMAIL;TYPE=INTERNET;TYPE=HOME:");
        sb.append(user.getEmailAddress());
        sb.append("\n");
        for (EmailAddress emailAddress : emailAddresses) {
            sb.append("EMAIL;TYPE=INTERNET;TYPE=");
            ListType listType = emailAddress.getType();
            sb.append(StringUtil.toUpperCase(listType.getName()));
            sb.append(":");
            sb.append(emailAddress.getAddress());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String _getFooter() {
        return "END:VCARD\n";
    }

    private static String _getHeader() {
        return "BEGIN:VCARD\nVERSION:3.0\n";
    }

    private static String _getInstantMessaging(Contact contact) {
        StringBundler sb = new StringBundler(6);
        if (Validator.isNotNull(contact.getJabberSn())) {
            sb.append("X-JABBER;type=OTHER;type=pref:");
            sb.append(contact.getJabberSn());
            sb.append("\n");
        }
        if (Validator.isNotNull(contact.getSkypeSn())) {
            sb.append("X-SKYPE;type=OTHER;type=pref:");
            sb.append(contact.getSkypeSn());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String _getJobTitle(User user) {
        String jobTitle = user.getJobTitle();
        if (Validator.isNotNull(jobTitle)) {
            return "TITLE:".concat(jobTitle).concat("\n");
        }
        return "";
    }

    private static String _getName(User user, Contact contact) throws Exception {
        StringBundler sb = new StringBundler(14);
        sb.append("N:");
        sb.append(user.getLastName());
        sb.append(";");
        sb.append(user.getFirstName());
        sb.append(";");
        sb.append(user.getMiddleName());
        sb.append(";");
        long prefixId = contact.getPrefixId();
        if (prefixId > 0L) {
            ListType listType = ListTypeServiceUtil.getListType(prefixId);
            sb.append(listType.getName());
        }
        sb.append(";");
        long suffixId = contact.getSuffixId();
        if (suffixId > 0L) {
            ListType listType = ListTypeServiceUtil.getListType(suffixId);
            sb.append(listType.getName());
        }
        sb.append("\n");
        sb.append("FN:");
        sb.append(user.getFullName());
        sb.append("\n");
        return sb.toString();
    }

    private static String _getPhones(User user) throws Exception {
        List<Phone> phones = PhoneLocalServiceUtil.getPhones(user.getCompanyId(), Contact.class.getName(), user.getContactId());
        StringBundler sb = new StringBundler(phones.size() * 7);
        for (Phone phone : phones) {
            sb.append("TEL;TYPE=");
            ListType listType = phone.getType();
            sb.append(StringUtil.toUpperCase(ContactsUtil._getVCardListTypeName(listType)));
            sb.append(":");
            sb.append(phone.getNumber());
            sb.append(" ");
            sb.append(phone.getExtension());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String _getVCardListTypeName(ListType listType) {
        String listTypeName = listType.getName();
        if (StringUtil.equalsIgnoreCase(listTypeName, "business")) {
            listTypeName = "work";
        } else if (StringUtil.equalsIgnoreCase(listTypeName, "personal")) {
            listTypeName = "home";
        }
        return listTypeName;
    }

    private static String _getWebsites(User user) throws Exception {
        List<Website> websites = WebsiteLocalServiceUtil.getWebsites(user.getCompanyId(), Contact.class.getName(), user.getContactId());
        StringBundler sb = new StringBundler(websites.size() * 5);
        for (Website website : websites) {
            sb.append("URL;TYPE=");
            ListType listType = website.getType();
            sb.append(StringUtil.toUpperCase(ContactsUtil._getVCardListTypeName(listType)));
            sb.append(":");
            String url = website.getUrl();
            sb.append(url.replaceAll(":", "\\:"));
            sb.append("\n");
        }
        return sb.toString();
    }
}

