/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.upgrade;

import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.List;

public class UpgradeDiscussionSubscriptionClassName
extends UpgradeProcess {
    private final DeletionMode _deletionMode;
    private final String _oldSubscriptionClassName;
    private final SubscriptionLocalService _subscriptionLocalService;

    public UpgradeDiscussionSubscriptionClassName(SubscriptionLocalService subscriptionLocalService, String oldSubscriptionClassName, DeletionMode deletionMode) {
        this._subscriptionLocalService = subscriptionLocalService;
        this._oldSubscriptionClassName = oldSubscriptionClassName;
        this._deletionMode = deletionMode;
    }

    @Override
    protected void doUpgrade() throws Exception {
        this._addSubscriptions();
        if (this._deletionMode == DeletionMode.DELETE_OLD) {
            this._deleteSubscriptions();
        }
    }

    private void _addSubscriptions() throws PortalException {
        String newSubscriptionClassName = MBDiscussion.class.getName() + "_" + this._oldSubscriptionClassName;
        if (this._subscriptionLocalService.getSubscriptionsCount(newSubscriptionClassName) > 0) {
            return;
        }
        List<Subscription> subscriptions = this._subscriptionLocalService.getSubscriptions(this._oldSubscriptionClassName);
        for (Subscription subscription : subscriptions) {
            this._subscriptionLocalService.addSubscription(subscription.getUserId(), subscription.getGroupId(), newSubscriptionClassName, subscription.getClassPK());
        }
    }

    private void _deleteSubscriptions() throws PortalException {
        List<Subscription> subscriptions = this._subscriptionLocalService.getSubscriptions(this._oldSubscriptionClassName);
        for (Subscription subscription : subscriptions) {
            this._subscriptionLocalService.deleteSubscription(subscription.getSubscriptionId());
        }
    }

    public static enum DeletionMode {
        ADD_NEW,
        DELETE_OLD;

    }
}

