/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.taglib.internal.struts;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.message.boards.exception.DiscussionMaxCommentsException;
import com.liferay.message.boards.exception.MessageBodyException;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.exception.RequiredMessageException;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFunction;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/portal/comment/discussion/edit"}, service={StrutsAction.class})
public class EditDiscussionStrutsAction
implements StrutsAction {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        AuthTokenUtil.checkCSRFToken(httpServletRequest, EditDiscussionStrutsAction.class.getName());
        String namespace = ParamUtil.getString(httpServletRequest, "namespace");
        NamespaceServletRequest namespacedHttpServletRequest = new NamespaceServletRequest(httpServletRequest, "", namespace);
        String cmd = ParamUtil.getString((HttpServletRequest)namespacedHttpServletRequest, "cmd");
        try {
            String redirect = this._portal.escapeRedirect(ParamUtil.getString((HttpServletRequest)namespacedHttpServletRequest, "redirect"));
            if (cmd.equals("add") || cmd.equals("update")) {
                long commentId = this.updateComment((HttpServletRequest)namespacedHttpServletRequest);
                boolean ajax = ParamUtil.getBoolean((HttpServletRequest)namespacedHttpServletRequest, "ajax", true);
                if (ajax) {
                    String randomNamespace = ParamUtil.getString((HttpServletRequest)namespacedHttpServletRequest, "randomNamespace");
                    JSONObject jsonObject = JSONUtil.put("commentId", (Object)commentId).put("randomNamespace", randomNamespace);
                    this.writeJSON((HttpServletRequest)namespacedHttpServletRequest, httpServletResponse, jsonObject);
                    return null;
                }
            } else if (cmd.equals("delete")) {
                this.deleteComment((HttpServletRequest)namespacedHttpServletRequest);
            } else if (cmd.equals("subscribe_to_comments")) {
                this.subscribeToComments((HttpServletRequest)namespacedHttpServletRequest, true);
            } else if (cmd.equals("unsubscribe_from_comments")) {
                this.subscribeToComments((HttpServletRequest)namespacedHttpServletRequest, false);
            }
            if (Validator.isNotNull(redirect)) {
                httpServletResponse.sendRedirect(redirect);
            }
        }
        catch (DiscussionMaxCommentsException | MessageBodyException | NoSuchMessageException | RequiredMessageException | PrincipalException e) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.putException(e);
            this.writeJSON((HttpServletRequest)namespacedHttpServletRequest, httpServletResponse, jsonObject);
        }
        return null;
    }

    protected void deleteComment(HttpServletRequest httpServletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long commentId = ParamUtil.getLong(httpServletRequest, "commentId");
        DiscussionPermission discussionPermission = this._getDiscussionPermission(themeDisplay);
        discussionPermission.checkDeletePermission(commentId);
        this._commentManager.deleteComment(commentId);
    }

    protected void subscribeToComments(HttpServletRequest httpServletRequest, boolean subscribe) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DiscussionPermission discussionPermission = this._getDiscussionPermission(themeDisplay);
        String className = ParamUtil.getString(httpServletRequest, "className");
        long classPK = ParamUtil.getLong(httpServletRequest, "classPK");
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(className, classPK);
        discussionPermission.checkSubscribePermission(assetEntry.getCompanyId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK());
        if (subscribe) {
            this._commentManager.subscribeDiscussion(themeDisplay.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK());
        } else {
            this._commentManager.unsubscribeDiscussion(themeDisplay.getUserId(), assetEntry.getClassName(), assetEntry.getClassPK());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long updateComment(HttpServletRequest httpServletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long commentId = ParamUtil.getLong(httpServletRequest, "commentId");
        String className = ParamUtil.getString(httpServletRequest, "className");
        long classPK = ParamUtil.getLong(httpServletRequest, "classPK");
        long parentCommentId = ParamUtil.getLong(httpServletRequest, "parentCommentId");
        String subject = ParamUtil.getString(httpServletRequest, "subject");
        String body = ParamUtil.getString(httpServletRequest, "body");
        ServiceContextFunction serviceContextFunction = new ServiceContextFunction(httpServletRequest);
        DiscussionPermission discussionPermission = this._getDiscussionPermission(themeDisplay);
        AssetEntry assetEntry = this._getAssetEntry(commentId, className, classPK);
        if (commentId <= 0L) {
            User user = null;
            if (themeDisplay.isSignedIn()) {
                user = themeDisplay.getUser();
            } else {
                String emailAddress = ParamUtil.getString(httpServletRequest, "emailAddress");
                user = this._userLocalService.fetchUserByEmailAddress(themeDisplay.getCompanyId(), emailAddress);
                if (user == null || user.getStatus() != 6) {
                    return 0L;
                }
            }
            String name = PrincipalThreadLocal.getName();
            PrincipalThreadLocal.setName(user.getUserId());
            try {
                discussionPermission.checkAddPermission(assetEntry.getCompanyId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK());
                commentId = this._commentManager.addComment(user.getUserId(), assetEntry.getClassName(), assetEntry.getClassPK(), user.getFullName(), parentCommentId, subject, body, (Function<String, ServiceContext>)serviceContextFunction);
            }
            finally {
                PrincipalThreadLocal.setName(name);
            }
        } else {
            discussionPermission.checkUpdatePermission(commentId);
            commentId = this._commentManager.updateComment(themeDisplay.getUserId(), assetEntry.getClassName(), assetEntry.getClassPK(), commentId, subject, body, serviceContextFunction);
        }
        if (PropsValues.DISCUSSION_SUBSCRIBE) {
            this._commentManager.subscribeDiscussion(themeDisplay.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK());
        }
        return commentId;
    }

    protected void writeJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object jsonObj) throws IOException {
        httpServletResponse.setContentType("application/json");
        ServletResponseUtil.write(httpServletResponse, jsonObj.toString());
        httpServletResponse.flushBuffer();
    }

    private AssetEntry _getAssetEntry(long commentId, String className, long classPK) throws PortalException {
        if (Validator.isNotNull(className) && classPK > 0L) {
            return this._assetEntryLocalService.getEntry(className, classPK);
        }
        Comment comment = this._commentManager.fetchComment(commentId);
        return this._assetEntryLocalService.getEntry(comment.getClassName(), comment.getClassPK());
    }

    private DiscussionPermission _getDiscussionPermission(ThemeDisplay themeDisplay) throws PrincipalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(themeDisplay.getPermissionChecker());
        if (discussionPermission == null) {
            throw new PrincipalException("Discussion permission is null");
        }
        return discussionPermission;
    }
}

