/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.taglib.internal.context;

import com.liferay.comment.constants.CommentConstants;
import com.liferay.comment.taglib.internal.context.BaseCommentDisplayContext;
import com.liferay.comment.taglib.internal.context.util.DiscussionRequestHelper;
import com.liferay.comment.taglib.internal.context.util.DiscussionTaglibHelper;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.WorkflowableComment;
import com.liferay.portal.kernel.comment.display.context.CommentTreeDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.Locale;

public class DefaultCommentTreeDisplayContext
extends BaseCommentDisplayContext
implements CommentTreeDisplayContext {
    private final DiscussionComment _discussionComment;
    private final DiscussionPermission _discussionPermission;
    private final DiscussionRequestHelper _discussionRequestHelper;
    private final DiscussionTaglibHelper _discussionTaglibHelper;
    private Boolean _hasUpdatePermission;

    public DefaultCommentTreeDisplayContext(DiscussionRequestHelper discussionRequestHelper, DiscussionTaglibHelper discussionTaglibHelper, DiscussionPermission discussionPermission, DiscussionComment discussionComment) {
        this._discussionRequestHelper = discussionRequestHelper;
        this._discussionTaglibHelper = discussionTaglibHelper;
        this._discussionPermission = discussionPermission;
        this._discussionComment = discussionComment;
    }

    @Override
    public String getPublishButtonLabel(Locale locale) {
        String publishButtonLabel = LanguageUtil.get(this._discussionRequestHelper.getRequest(), "save");
        if (WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink(this._discussionRequestHelper.getCompanyId(), this._discussionRequestHelper.getScopeGroupId(), CommentConstants.getDiscussionClassName()) && !this.isCommentPending()) {
            publishButtonLabel = LanguageUtil.get(this._discussionRequestHelper.getRequest(), "submit-for-publication");
        }
        return publishButtonLabel;
    }

    @Override
    public boolean isActionControlsVisible() throws PortalException {
        if (this._discussionComment == null || this._discussionTaglibHelper.isHideControls() || this._isStagingGroup()) {
            return false;
        }
        return !this._discussionComment.isInTrash();
    }

    @Override
    public boolean isDeleteActionControlVisible() throws PortalException {
        if (this._discussionPermission == null || this._isStagingGroup()) {
            return false;
        }
        return this._discussionPermission.hasPermission(this._discussionComment, "DELETE_DISCUSSION");
    }

    @Override
    public boolean isDiscussionVisible() throws PortalException {
        if (!(this.isCommentApproved() || this.isCommentAuthor() || this.isGroupAdmin())) {
            return false;
        }
        return this.hasViewPermission();
    }

    @Override
    public boolean isEditActionControlVisible() throws PortalException {
        return this.hasUpdatePermission() && !this._isStagingGroup();
    }

    @Override
    public boolean isEditControlsVisible() throws PortalException {
        if (this._discussionTaglibHelper.isHideControls() || this._isStagingGroup()) {
            return false;
        }
        return this.hasUpdatePermission();
    }

    @Override
    public boolean isRatingsVisible() throws PortalException {
        if (this._discussionComment == null || !this._discussionTaglibHelper.isRatingsEnabled()) {
            return false;
        }
        return !this._discussionComment.isInTrash();
    }

    @Override
    public boolean isReplyActionControlVisible() throws PortalException {
        if (this._discussionPermission == null || this._isStagingGroup()) {
            return false;
        }
        return this._discussionPermission.hasAddPermission(this._discussionRequestHelper.getCompanyId(), this._discussionRequestHelper.getScopeGroupId(), this._discussionTaglibHelper.getClassName(), this._discussionTaglibHelper.getClassPK());
    }

    @Override
    public boolean isWorkflowStatusVisible() {
        return this._discussionComment != null && !this.isCommentApproved();
    }

    @Override
    protected ThemeDisplay getThemeDisplay() {
        return this._discussionRequestHelper.getThemeDisplay();
    }

    protected User getUser() {
        ThemeDisplay themeDisplay = this._discussionRequestHelper.getThemeDisplay();
        return themeDisplay.getUser();
    }

    protected boolean hasUpdatePermission() throws PortalException {
        if (this._discussionPermission == null) {
            return false;
        }
        if (this._hasUpdatePermission == null) {
            this._hasUpdatePermission = this._discussionPermission.hasPermission(this._discussionComment, "UPDATE_DISCUSSION");
        }
        return this._hasUpdatePermission;
    }

    protected boolean hasViewPermission() throws PortalException {
        if (this._discussionPermission == null) {
            return false;
        }
        return this._discussionPermission.hasViewPermission(this._discussionRequestHelper.getCompanyId(), this._discussionRequestHelper.getScopeGroupId(), this._discussionTaglibHelper.getClassName(), this._discussionTaglibHelper.getClassPK());
    }

    protected boolean isCommentApproved() {
        boolean approved = true;
        if (this._discussionComment instanceof WorkflowableComment) {
            WorkflowableComment workflowableComment = (WorkflowableComment)((Object)this._discussionComment);
            approved = workflowableComment.getStatus() == 0;
        }
        return approved;
    }

    protected boolean isCommentAuthor() {
        User user = this.getUser();
        return this._discussionComment != null && this._discussionComment.getUserId() == user.getUserId() && !user.isDefaultUser();
    }

    protected boolean isCommentPending() {
        boolean pending = false;
        if (this._discussionComment instanceof WorkflowableComment) {
            WorkflowableComment workflowableComment = (WorkflowableComment)((Object)this._discussionComment);
            pending = workflowableComment.getStatus() == 1;
        }
        return pending;
    }

    protected boolean isGroupAdmin() {
        PermissionChecker permissionChecker = this._discussionRequestHelper.getPermissionChecker();
        return permissionChecker.isGroupAdmin(this._discussionRequestHelper.getScopeGroupId());
    }

    private boolean _isStagingGroup() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        Group siteGroup = themeDisplay.getSiteGroup();
        return siteGroup.isStagingGroup();
    }
}

