/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.function;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import java.util.Optional;
import java.util.function.Function;

public class CTFunctions {
    private static final Log _log = LogFactoryUtil.getLog(CTFunctions.class);

    public static <T extends ClassedModel> Function<T, Optional<Group>> getFetchGroupFunction() {
        return classedModel -> {
            long groupId = BeanPropertiesUtil.getLongSilent(classedModel, "groupId");
            Group group = GroupLocalServiceUtil.fetchGroup(groupId);
            return Optional.ofNullable(group);
        };
    }

    public static <T extends ClassedModel> Function<T, String> getFetchSiteNameFunction() {
        return classedModel -> {
            Optional<Group> groupOptional = CTFunctions.getFetchGroupFunction().apply((ClassedModel)classedModel);
            if (!groupOptional.isPresent()) {
                return "";
            }
            try {
                Group group = groupOptional.get();
                return group.getDescriptiveName();
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to get group descriptive name for classed model " + classedModel, pe);
                }
                return "";
            }
        };
    }
}

