/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.util;

import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import java.util.Calendar;
import java.util.TimeZone;

public class JCalendarUtil {
    public static final long DAY = 86400000L;
    public static final long HOUR = 3600000L;
    public static final long MINUTE = 60000L;
    public static final long MONTH = 2592000000L;
    public static final long SECOND = 1000L;
    private static final TimeZone _utcTimeZone = TimeZone.getTimeZone("UTC");

    public static long convertTimeToNewDay(long oldTime, long newTime) {
        Calendar oldJCalendar = JCalendarUtil.getJCalendar(oldTime);
        Calendar newJCalendar = JCalendarUtil.getJCalendar(newTime);
        newJCalendar.set(9, oldJCalendar.get(9));
        newJCalendar.set(10, oldJCalendar.get(10));
        newJCalendar.set(12, oldJCalendar.get(12));
        newJCalendar.set(13, oldJCalendar.get(13));
        return newJCalendar.getTimeInMillis();
    }

    public static long getDaysBetween(Calendar startTimeJCalendar, Calendar endTimeJCalendar) {
        startTimeJCalendar = JCalendarUtil.toMidnightJCalendar(startTimeJCalendar);
        endTimeJCalendar = JCalendarUtil.toMidnightJCalendar(endTimeJCalendar);
        long startTime = startTimeJCalendar.getTimeInMillis();
        long endTime = endTimeJCalendar.getTimeInMillis();
        return (endTime - startTime) / 86400000L;
    }

    public static int getDSTShift(Calendar jCalendar1, Calendar jCalendar2, TimeZone timeZone) {
        jCalendar1 = JCalendarUtil.getJCalendar(jCalendar1.getTimeInMillis(), timeZone);
        jCalendar2 = JCalendarUtil.getJCalendar(jCalendar2.getTimeInMillis(), timeZone);
        Calendar sameDayJCalendar = JCalendarUtil.getJCalendar(jCalendar1.get(1), jCalendar1.get(2), jCalendar1.get(5), jCalendar2.get(11), jCalendar2.get(12), jCalendar2.get(13), jCalendar2.get(14), timeZone);
        Long shift = jCalendar1.getTimeInMillis() - sameDayJCalendar.getTimeInMillis();
        return shift.intValue();
    }

    public static Calendar getJCalendar(Calendar jCalendar, TimeZone timeZone) {
        return CalendarFactoryUtil.getCalendar(jCalendar.getTimeInMillis(), timeZone);
    }

    public static Calendar getJCalendar(int year, int month, int day, int hour, int minutes, int seconds, int milliseconds, TimeZone timeZone) {
        Calendar jCalendar = CalendarFactoryUtil.getCalendar(timeZone);
        jCalendar.set(1, year);
        jCalendar.set(2, month);
        jCalendar.set(5, day);
        jCalendar.set(11, hour);
        jCalendar.set(12, minutes);
        jCalendar.set(13, seconds);
        jCalendar.set(14, milliseconds);
        return jCalendar;
    }

    public static Calendar getJCalendar(long time) {
        return JCalendarUtil.getJCalendar(time, _utcTimeZone);
    }

    public static Calendar getJCalendar(long time, TimeZone timeZone) {
        Calendar jCalendar = CalendarFactoryUtil.getCalendar(timeZone);
        jCalendar.setTimeInMillis(time);
        return jCalendar;
    }

    public static int getTimeZoneOffset(TimeZone timeZone) {
        return timeZone.getOffset(System.currentTimeMillis());
    }

    public static boolean isLaterDay(Calendar jCalendar1, Calendar jCalendar2) {
        Calendar adjustedJCalendar2;
        Calendar adjustedJCalendar1 = JCalendarUtil.toLastHourJCalendar(jCalendar1);
        return adjustedJCalendar1.after(adjustedJCalendar2 = JCalendarUtil.toLastHourJCalendar(jCalendar2));
    }

    public static boolean isSameDayOfWeek(Calendar jCalendar1, Calendar jCalendar2) {
        int dayOfWeek2;
        int dayOfWeek1 = jCalendar1.get(7);
        return dayOfWeek1 == (dayOfWeek2 = jCalendar2.get(7));
    }

    public static Calendar mergeJCalendar(Calendar dateJCalendar, Calendar timeJCalendar, TimeZone timeZone) {
        return CalendarFactoryUtil.getCalendar(dateJCalendar.get(1), dateJCalendar.get(2), dateJCalendar.get(5), timeJCalendar.get(11), timeJCalendar.get(12), timeJCalendar.get(13), timeJCalendar.get(14), timeZone);
    }

    public static Calendar toLastHourJCalendar(Calendar jCalendar) {
        Calendar lastHourJCalendar = (Calendar)jCalendar.clone();
        lastHourJCalendar.set(11, 23);
        lastHourJCalendar.set(12, 59);
        lastHourJCalendar.set(13, 59);
        lastHourJCalendar.set(14, 999);
        return lastHourJCalendar;
    }

    public static Calendar toMidnightJCalendar(Calendar jCalendar) {
        Calendar midnightJCalendar = (Calendar)jCalendar.clone();
        midnightJCalendar.set(11, 0);
        midnightJCalendar.set(12, 0);
        midnightJCalendar.set(13, 0);
        midnightJCalendar.set(14, 0);
        return midnightJCalendar;
    }
}

