/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.util;

import com.liferay.calendar.model.CalendarResource;
import com.liferay.calendar.service.CalendarResourceLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.Locale;

public class CalendarResourceUtil {
    public static CalendarResource fetchGuestCalendarResource(long companyId) throws PortalException {
        return CalendarResourceLocalServiceUtil.fetchCalendarResource(PortalUtil.getClassNameId(User.class), UserLocalServiceUtil.getDefaultUserId(companyId));
    }

    public static CalendarResource getGroupCalendarResource(long groupId, ServiceContext serviceContext) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        if (group.isUser()) {
            return null;
        }
        CalendarResource calendarResource = CalendarResourceLocalServiceUtil.fetchCalendarResource(PortalUtil.getClassNameId(Group.class), groupId);
        if (calendarResource != null) {
            return calendarResource;
        }
        if (group.hasStagingGroup() && group.isStagedPortlet("com_liferay_calendar_web_portlet_CalendarPortlet")) {
            return null;
        }
        long userId = group.getCreatorUserId();
        User user = UserLocalServiceUtil.fetchUserById(userId);
        if (user == null || user.isDefaultUser()) {
            Role role = RoleLocalServiceUtil.getRole(group.getCompanyId(), "Administrator");
            long[] userIds = UserLocalServiceUtil.getRoleUserIds(role.getRoleId());
            userId = userIds[0];
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), group.getDescriptiveName());
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        return CalendarResourceLocalServiceUtil.addCalendarResource(userId, groupId, PortalUtil.getClassNameId(Group.class), groupId, null, null, nameMap, descriptionMap, true, serviceContext);
    }

    public static CalendarResource getUserCalendarResource(long userId, ServiceContext serviceContext) throws PortalException {
        long classNameId = PortalUtil.getClassNameId(User.class);
        CalendarResource calendarResource = CalendarResourceLocalServiceUtil.fetchCalendarResource(classNameId, userId);
        if (calendarResource != null) {
            return calendarResource;
        }
        User user = UserLocalServiceUtil.getUser(userId);
        Group userGroup = null;
        String userName = user.getFullName();
        if (user.isDefaultUser()) {
            userGroup = GroupLocalServiceUtil.getGroup(serviceContext.getCompanyId(), "Guest");
            userName = "Guest";
        } else {
            userGroup = GroupLocalServiceUtil.getUserGroup(serviceContext.getCompanyId(), userId);
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), userName);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        return CalendarResourceLocalServiceUtil.addCalendarResource(userId, userGroup.getGroupId(), PortalUtil.getClassNameId(User.class), userId, null, null, nameMap, descriptionMap, true, serviceContext);
    }
}

