/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.util;

import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.liferay.calendar.model.CalendarBooking;
import com.liferay.calendar.recurrence.Recurrence;
import com.liferay.calendar.util.JCalendarUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;

public class CalendarBookingIterator
implements Iterator<CalendarBooking> {
    private static final Log _log = LogFactoryUtil.getLog(CalendarBookingIterator.class);
    private final CalendarBooking _calendarBooking;
    private DateValue _currentDateValue;
    private int _instanceIndex;
    private final RecurrenceIterator _recurrenceIterator;

    public CalendarBookingIterator(CalendarBooking calendarBooking) throws ParseException {
        this._calendarBooking = calendarBooking;
        this._recurrenceIterator = RecurrenceIteratorFactory.createRecurrenceIterator(calendarBooking.getRecurrence(), this._toDateValue(calendarBooking.getStartTime()), calendarBooking.getTimeZone());
    }

    @Override
    public boolean hasNext() {
        return this._recurrenceIterator.hasNext() && !this._isExceededCount();
    }

    @Override
    public CalendarBooking next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        CalendarBooking newCalendarBooking = (CalendarBooking)this._calendarBooking.clone();
        this._currentDateValue = this._recurrenceIterator.next();
        Calendar jCalendar = this._getStartTimeJCalendar(this._currentDateValue);
        newCalendarBooking.setEndTime(jCalendar.getTimeInMillis() + this._calendarBooking.getDuration());
        newCalendarBooking.setInstanceIndex(this._instanceIndex);
        newCalendarBooking.setStartTime(jCalendar.getTimeInMillis());
        ++this._instanceIndex;
        return newCalendarBooking;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Calendar _getStartTimeJCalendar(DateValue dateValue) {
        Calendar jCalendar = JCalendarUtil.getJCalendar(this._calendarBooking.getStartTime(), this._getTimeZone(this._calendarBooking));
        Calendar startTimeJCalendar = JCalendarUtil.getJCalendar(dateValue.year(), dateValue.month() - 1, dateValue.day(), jCalendar.get(11), jCalendar.get(12), jCalendar.get(13), jCalendar.get(14), this._getTimeZone(this._calendarBooking));
        TimeZone timeZone = this._getTimeZone(this._calendarBooking);
        int shift = JCalendarUtil.getDSTShift(jCalendar, startTimeJCalendar, timeZone);
        startTimeJCalendar.add(14, shift);
        return startTimeJCalendar;
    }

    private TimeZone _getTimeZone(CalendarBooking calendarBooking) {
        try {
            if (calendarBooking.isAllDay()) {
                return TimeZone.getTimeZone("UTC");
            }
            return calendarBooking.getTimeZone();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e, e);
            }
            return TimeZoneUtil.getDefault();
        }
    }

    private boolean _isExceededCount() {
        Recurrence recurrence = this._calendarBooking.getRecurrenceObj();
        if (recurrence == null) {
            return false;
        }
        int count = recurrence.getCount();
        return count != 0 && this._instanceIndex >= count;
    }

    private DateValue _toDateValue(long time) {
        Calendar jCalendar = JCalendarUtil.getJCalendar(time, this._getTimeZone(this._calendarBooking));
        return new DateValueImpl(jCalendar.get(1), jCalendar.get(2) + 1, jCalendar.get(5));
    }
}

