/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.recurrence;

import java.util.Calendar;
import java.util.Objects;

public enum Weekday {
    SUNDAY("SU", 1),
    MONDAY("MO", 2),
    TUESDAY("TU", 3),
    WEDNESDAY("WE", 4),
    THURSDAY("TH", 5),
    FRIDAY("FR", 6),
    SATURDAY("SA", 7);

    private final int _calendarWeekday;
    private final String _value;

    public static Weekday getWeekday(Calendar jCalendar) {
        return Weekday.getWeekday(jCalendar.get(7));
    }

    public static Weekday getWeekday(int dayOfTheWeek) {
        if (dayOfTheWeek == 1) {
            return SUNDAY;
        }
        if (dayOfTheWeek == 2) {
            return MONDAY;
        }
        if (dayOfTheWeek == 3) {
            return TUESDAY;
        }
        if (dayOfTheWeek == 4) {
            return WEDNESDAY;
        }
        if (dayOfTheWeek == 5) {
            return THURSDAY;
        }
        if (dayOfTheWeek == 6) {
            return FRIDAY;
        }
        if (dayOfTheWeek == 7) {
            return SATURDAY;
        }
        throw new IllegalArgumentException("Invalid value " + dayOfTheWeek);
    }

    public static Weekday parse(String value) {
        if (Objects.equals(SUNDAY.getValue(), value)) {
            return SUNDAY;
        }
        if (Objects.equals(MONDAY.getValue(), value)) {
            return MONDAY;
        }
        if (Objects.equals(TUESDAY.getValue(), value)) {
            return TUESDAY;
        }
        if (Objects.equals(WEDNESDAY.getValue(), value)) {
            return WEDNESDAY;
        }
        if (Objects.equals(THURSDAY.getValue(), value)) {
            return THURSDAY;
        }
        if (Objects.equals(FRIDAY.getValue(), value)) {
            return FRIDAY;
        }
        if (Objects.equals(SATURDAY.getValue(), value)) {
            return SATURDAY;
        }
        throw new IllegalArgumentException("Invalid value " + value);
    }

    public int getCalendarWeekday() {
        return this._calendarWeekday;
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        return this._value;
    }

    private Weekday(String value, int calendarWeekday) {
        this._value = value;
        this._calendarWeekday = calendarWeekday;
    }
}

