/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.io.Serializable;
import java.util.Map;

public abstract class BaseMultipleEntryBulkSelection<T>
implements BulkSelection<T> {
    private final long[] _entryIds;
    private final Language _language;
    private final Map<String, String[]> _parameterMap;
    private final ResourceBundleLoader _resourceBundleLoader;

    public BaseMultipleEntryBulkSelection(long[] entryIds, Map<String, String[]> parameterMap, ResourceBundleLoader resourceBundleLoader, Language language) {
        this._entryIds = entryIds;
        this._parameterMap = parameterMap;
        this._resourceBundleLoader = resourceBundleLoader;
        this._language = language;
    }

    @Override
    public <E extends PortalException> void forEach(UnsafeConsumer<T, E> unsafeConsumer) throws PortalException {
        for (long entryId : this._entryIds) {
            unsafeConsumer.accept(this.fetchEntry(entryId));
        }
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this._parameterMap;
    }

    @Override
    public long getSize() {
        return this._entryIds.length;
    }

    @Override
    public Serializable serialize() {
        return StringUtil.merge(this._entryIds, ",");
    }

    protected abstract T fetchEntry(long var1);
}

