/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.test.util;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.bookmarks.service.BookmarksEntryServiceUtil;
import com.liferay.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.io.Serializable;

public class BookmarksTestUtil {
    public static BookmarksEntry addEntry(boolean approved) throws Exception {
        return BookmarksTestUtil.addEntry(TestPropsValues.getGroupId(), approved);
    }

    public static BookmarksEntry addEntry(long groupId, boolean approved) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(groupId);
        return BookmarksTestUtil.addEntry(0L, approved, serviceContext);
    }

    public static BookmarksEntry addEntry(long folderId, boolean approved, ServiceContext serviceContext) throws Exception {
        return BookmarksTestUtil.addEntry("Test Entry", folderId, approved, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BookmarksEntry addEntry(String name, long folderId, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled(true);
            String url = "http://www.liferay.com";
            String description = "This is a test entry.";
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            BookmarksEntry entry = BookmarksEntryServiceUtil.addEntry(serviceContext.getScopeGroupId(), folderId, name, url, description, serviceContext);
            serviceContext.setCommand("add");
            serviceContext.setLayoutFullURL("http://localhost");
            if (approved) {
                entry.setStatus(0);
                entry = BookmarksEntryServiceUtil.updateEntry(entry.getEntryId(), serviceContext.getScopeGroupId(), entry.getFolderId(), entry.getName(), entry.getUrl(), entry.getUrl(), serviceContext);
            }
            BookmarksEntry bookmarksEntry = entry;
            return bookmarksEntry;
        }
        finally {
            WorkflowThreadLocal.setEnabled(workflowEnabled);
        }
    }

    public static BookmarksFolder addFolder(long groupId, long parentFolderId, String name) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(groupId);
        return BookmarksTestUtil.addFolder(parentFolderId, name, serviceContext);
    }

    public static BookmarksFolder addFolder(long groupId, String name) throws Exception {
        return BookmarksTestUtil.addFolder(groupId, 0L, name);
    }

    public static BookmarksFolder addFolder(long parentFolderId, String name, ServiceContext serviceContext) throws Exception {
        String description = "This is a test folder.";
        return BookmarksFolderServiceUtil.addFolder(parentFolderId, name, description, serviceContext);
    }

    public static BookmarksFolder addFolder(String name) throws Exception {
        return BookmarksTestUtil.addFolder(TestPropsValues.getGroupId(), name);
    }

    public static SearchContext getSearchContext(long companyId, long groupId, long folderId, String keywords) {
        return BookmarksTestUtil.getSearchContext(companyId, groupId, folderId, keywords, false, false);
    }

    public static SearchContext getSearchContext(long companyId, long groupId, long folderId, String keywords, boolean highlight, boolean score) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setFolderIds(new long[]{folderId});
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(keywords);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(highlight);
        queryConfig.setScoreEnabled(score);
        return searchContext;
    }

    public static void populateNotificationsServiceContext(ServiceContext serviceContext, String command) throws Exception {
        serviceContext.setAttribute("entryURL", (Serializable)((Object)"http://localhost"));
        if (Validator.isNotNull(command)) {
            serviceContext.setCommand(command);
        }
        serviceContext.setLayoutFullURL("http://localhost");
    }

    public static BookmarksEntry updateEntry(BookmarksEntry entry) throws Exception {
        return BookmarksTestUtil.updateEntry(entry, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    public static BookmarksEntry updateEntry(BookmarksEntry entry, String name) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(entry.getGroupId());
        serviceContext.setCommand("update");
        serviceContext.setLayoutFullURL("http://localhost");
        return BookmarksEntryLocalServiceUtil.updateEntry(TestPropsValues.getUserId(), entry.getEntryId(), entry.getGroupId(), entry.getFolderId(), name, entry.getUrl(), entry.getDescription(), serviceContext);
    }
}

