/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.test.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyServiceUtil;
import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class AssetTestUtil {
    public static AssetEntry addAssetEntry(long groupId) {
        return AssetTestUtil.addAssetEntry(groupId, null);
    }

    public static AssetEntry addAssetEntry(long groupId, Date publishDate) {
        return AssetTestUtil.addAssetEntry(groupId, publishDate, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    public static AssetEntry addAssetEntry(long groupId, Date publishDate, String className) {
        long assetEntryId = CounterLocalServiceUtil.increment();
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.createAssetEntry(assetEntryId);
        assetEntry.setClassName(className);
        assetEntry.setGroupId(groupId);
        assetEntry.setClassPK(RandomTestUtil.randomLong());
        assetEntry.setVisible(true);
        assetEntry.setPublishDate(publishDate);
        return AssetEntryLocalServiceUtil.updateAssetEntry(assetEntry);
    }

    public static AssetCategory addCategory(long groupId, long vocabularyId) throws Exception {
        return AssetTestUtil.addCategory(groupId, vocabularyId, 0L);
    }

    public static AssetCategory addCategory(long groupId, long vocabularyId, long parentCategoryId) throws Exception {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getSiteDefault();
        titleMap.put(locale, RandomTestUtil.randomString(new RandomizerBumper[0]));
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, RandomTestUtil.randomString(new RandomizerBumper[0]));
        String[] categoryProperties = null;
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(groupId, TestPropsValues.getUserId());
        return AssetCategoryLocalServiceUtil.addCategory(TestPropsValues.getUserId(), groupId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    public static AssetTag addTag(long groupId) throws Exception {
        return AssetTestUtil.addTag(groupId, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    public static AssetTag addTag(long groupId, String assetTagName) throws PortalException {
        long userId = TestPropsValues.getUserId();
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(groupId, userId);
        return AssetTagLocalServiceUtil.addTag(userId, groupId, assetTagName, serviceContext);
    }

    public static AssetVocabulary addVocabulary(long groupId) throws Exception {
        long userId = TestPropsValues.getUserId();
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(groupId, userId);
        return AssetVocabularyLocalServiceUtil.addVocabulary(userId, groupId, RandomTestUtil.randomString(new RandomizerBumper[0]), serviceContext);
    }

    public static AssetVocabulary addVocabulary(long groupId, long classNameId, long classTypePK, boolean required) throws Exception {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getSiteDefault();
        titleMap.put(locale, RandomTestUtil.randomString(new RandomizerBumper[0]));
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, RandomTestUtil.randomString(new RandomizerBumper[0]));
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(new long[]{classNameId}, new long[]{classTypePK}, new boolean[]{required});
        vocabularySettingsHelper.setMultiValued(true);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(groupId, TestPropsValues.getUserId());
        return AssetVocabularyServiceUtil.addVocabulary(groupId, RandomTestUtil.randomString(new RandomizerBumper[0]), titleMap, descriptionMap, vocabularySettingsHelper.toString(), serviceContext);
    }
}

